<?php

if ( ! function_exists( 'cevian_core_map_portfolio_settings_meta' ) ) {
	function cevian_core_map_portfolio_settings_meta() {
		$meta_box = cevian_select_create_meta_box( array(
			'scope' => 'portfolio-item',
			'title' => esc_html__( 'Portfolio Settings', 'cevian-core' ),
			'name'  => 'portfolio_settings_meta_box'
		) );
		
		cevian_select_create_meta_box_field( array(
			'name'        => 'qodef_portfolio_single_template_meta',
			'type'        => 'select',
			'label'       => esc_html__( 'Portfolio Type', 'cevian-core' ),
			'description' => esc_html__( 'Choose a default type for Single Project pages', 'cevian-core' ),
			'parent'      => $meta_box,
			'options'     => array(
				''                  => esc_html__( 'Default', 'cevian-core' ),
				'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'cevian-core' ),
				'images'            => esc_html__( 'Portfolio Images', 'cevian-core' ),
				'small-images'      => esc_html__( 'Portfolio Small Images', 'cevian-core' ),
				'slider'            => esc_html__( 'Portfolio Slider', 'cevian-core' ),
				'small-slider'      => esc_html__( 'Portfolio Small Slider', 'cevian-core' ),
				'gallery'           => esc_html__( 'Portfolio Gallery', 'cevian-core' ),
				'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'cevian-core' ),
				'masonry'           => esc_html__( 'Portfolio Masonry', 'cevian-core' ),
				'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'cevian-core' ),
				'custom'            => esc_html__( 'Portfolio Custom', 'cevian-core' ),
				'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'cevian-core' )
			)
		) );
		
		/***************** Gallery Layout *****************/
		
		$gallery_type_meta_container = cevian_select_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'qodef_gallery_type_meta_container',
				'dependency' => array(
					'show' => array(
						'qodef_portfolio_single_template_meta'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_single_gallery_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'cevian-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'cevian-core' ),
				'parent'        => $gallery_type_meta_container,
				'options'       => cevian_select_get_number_of_columns_array( true, array( 'one', 'five', 'six' ) )
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_single_gallery_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'cevian-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'cevian-core' ),
				'default_value' => '',
				'options'       => cevian_select_get_space_between_items_array( true ),
				'parent'        => $gallery_type_meta_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$masonry_type_meta_container = cevian_select_add_admin_container(
			array(
				'parent'          => $meta_box,
				'name'            => 'qodef_masonry_type_meta_container',
				'dependency' => array(
					'show' => array(
						'qodef_portfolio_single_template_meta'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_single_masonry_columns_number_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'cevian-core' ),
				'default_value' => '',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'cevian-core' ),
				'parent'        => $masonry_type_meta_container,
				'options'       => cevian_select_get_number_of_columns_array( true, array( 'one', 'five', 'six' ) )
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_single_masonry_space_between_items_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'cevian-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'cevian-core' ),
				'default_value' => '',
				'options'       => cevian_select_get_space_between_items_array( true ),
				'parent'        => $masonry_type_meta_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_portfolio_single_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on your single portfolio page', 'cevian-core' ),
				'parent'        => $meta_box,
				'options'       => cevian_select_get_yes_no_select_array()
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'portfolio_info_top_padding',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Info Top Padding', 'cevian-core' ),
				'description' => esc_html__( 'Set top padding for portfolio info elements holder. This option works only for Portfolio Images, Slider, Gallery and Masonry portfolio types', 'cevian-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'portfolio_external_link',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio External Link', 'cevian-core' ),
				'description' => esc_html__( 'Enter URL to link from Portfolio List page', 'cevian-core' ),
				'parent'      => $meta_box,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_portfolio_featured_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Featured Image', 'cevian-core' ),
				'description' => esc_html__( 'Choose an image for Portfolio Lists shortcode where Hover Type option is Switch Featured Images', 'cevian-core' ),
				'parent'      => $meta_box
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_masonry_fixed_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Fixed Proportion', 'cevian-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is fixed', 'cevian-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''                   => esc_html__( 'Default', 'cevian-core' ),
					'small'              => esc_html__( 'Small', 'cevian-core' ),
					'large-width'        => esc_html__( 'Large Width', 'cevian-core' ),
					'large-height'       => esc_html__( 'Large Height', 'cevian-core' ),
					'large-width-height' => esc_html__( 'Large Width/Height', 'cevian-core' )
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_portfolio_masonry_original_dimensions_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Dimensions for Masonry - Image Original Proportion', 'cevian-core' ),
				'description'   => esc_html__( 'Choose image layout when it appears in Masonry type portfolio lists where image proportion is original', 'cevian-core' ),
				'default_value' => '',
				'parent'        => $meta_box,
				'options'       => array(
					''            => esc_html__( 'Default', 'cevian-core' ),
					'large-width' => esc_html__( 'Large Width', 'cevian-core' )
				)
			)
		);
		
		$all_pages = array();
		$pages     = get_pages();
		foreach ( $pages as $page ) {
			$all_pages[ $page->ID ] = $page->post_title;
		}
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'portfolio_single_back_to_link',
				'type'        => 'select',
				'label'       => esc_html__( '"Back To" Link', 'cevian-core' ),
				'description' => esc_html__( 'Choose "Back To" page to link from portfolio Single Project page', 'cevian-core' ),
				'parent'      => $meta_box,
				'options'     => $all_pages,
				'args'        => array(
					'select2' => true
				)
			)
		);
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_core_map_portfolio_settings_meta', 41 );
}