<?php

if ( ! function_exists( 'cevian_select_portfolio_options_map' ) ) {
	function cevian_select_portfolio_options_map() {
		
		cevian_select_add_admin_page(
			array(
				'slug'  => '_portfolio',
				'title' => esc_html__( 'Portfolio', 'cevian-core' ),
				'icon'  => 'fa fa-camera-retro'
			)
		);
		
		$panel_archive = cevian_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Archive', 'cevian-core' ),
				'name'  => 'panel_portfolio_archive',
				'page'  => '_portfolio'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'        => 'portfolio_archive_number_of_items',
				'type'        => 'text',
				'label'       => esc_html__( 'Number of Items', 'cevian-core' ),
				'description' => esc_html__( 'Set number of items for your portfolio list on archive pages. Default value is 12', 'cevian-core' ),
				'parent'      => $panel_archive,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_archive_number_of_columns',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'cevian-core' ),
				'default_value' => 'four',
				'description'   => esc_html__( 'Set number of columns for your portfolio list on archive pages. Default value is Four columns', 'cevian-core' ),
				'parent'        => $panel_archive,
				'options'       => cevian_select_get_number_of_columns_array( false, array( 'one', 'six' ) )
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_archive_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'cevian-core' ),
				'description'   => esc_html__( 'Set space size between portfolio items for your portfolio list on archive pages. Default value is normal', 'cevian-core' ),
				'default_value' => 'normal',
				'options'       => cevian_select_get_space_between_items_array(),
				'parent'        => $panel_archive
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_archive_image_size',
				'type'          => 'select',
				'label'         => esc_html__( 'Image Proportions', 'cevian-core' ),
				'default_value' => 'landscape',
				'description'   => esc_html__( 'Set image proportions for your portfolio list on archive pages. Default value is landscape', 'cevian-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'full'      => esc_html__( 'Original', 'cevian-core' ),
					'landscape' => esc_html__( 'Landscape', 'cevian-core' ),
					'portrait'  => esc_html__( 'Portrait', 'cevian-core' ),
					'square'    => esc_html__( 'Square', 'cevian-core' )
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_archive_item_layout',
				'type'          => 'select',
				'label'         => esc_html__( 'Item Style', 'cevian-core' ),
				'default_value' => 'standard-shader',
				'description'   => esc_html__( 'Set item style for your portfolio list on archive pages. Default value is Standard - Shader', 'cevian-core' ),
				'parent'        => $panel_archive,
				'options'       => array(
					'standard-shader' => esc_html__( 'Standard - Shader', 'cevian-core' ),
					'gallery-overlay' => esc_html__( 'Gallery - Overlay', 'cevian-core' )
				)
			)
		);
		
		$panel = cevian_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Portfolio Single', 'cevian-core' ),
				'name'  => 'panel_portfolio_single',
				'page'  => '_portfolio'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_template',
				'type'          => 'select',
				'label'         => esc_html__( 'Portfolio Type', 'cevian-core' ),
				'default_value' => 'small-images',
				'description'   => esc_html__( 'Choose a default type for Single Project pages', 'cevian-core' ),
				'parent'        => $panel,
				'options'       => array(
					'huge-images'       => esc_html__( 'Portfolio Full Width Images', 'cevian-core' ),
					'images'            => esc_html__( 'Portfolio Images', 'cevian-core' ),
					'small-images'      => esc_html__( 'Portfolio Small Images', 'cevian-core' ),
					'slider'            => esc_html__( 'Portfolio Slider', 'cevian-core' ),
					'small-slider'      => esc_html__( 'Portfolio Small Slider', 'cevian-core' ),
					'gallery'           => esc_html__( 'Portfolio Gallery', 'cevian-core' ),
					'small-gallery'     => esc_html__( 'Portfolio Small Gallery', 'cevian-core' ),
					'masonry'           => esc_html__( 'Portfolio Masonry', 'cevian-core' ),
					'small-masonry'     => esc_html__( 'Portfolio Small Masonry', 'cevian-core' ),
					'custom'            => esc_html__( 'Portfolio Custom', 'cevian-core' ),
					'full-width-custom' => esc_html__( 'Portfolio Full Width Custom', 'cevian-core' )
				)
			)
		);
		
		/***************** Gallery Layout *****************/
		
		$portfolio_gallery_container = cevian_select_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_gallery_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'gallery',
							'small-gallery'
						)
					)
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'cevian-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio gallery type', 'cevian-core' ),
				'parent'        => $portfolio_gallery_container,
				'options'       => cevian_select_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) )
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_gallery_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'cevian-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio gallery type', 'cevian-core' ),
				'default_value' => 'normal',
				'options'       => cevian_select_get_space_between_items_array(),
				'parent'        => $portfolio_gallery_container
			)
		);
		
		/***************** Gallery Layout *****************/
		
		/***************** Masonry Layout *****************/
		
		$portfolio_masonry_container = cevian_select_add_admin_container(
			array(
				'parent'          => $panel,
				'name'            => 'portfolio_masonry_container',
				'dependency' => array(
					'show' => array(
						'portfolio_single_template'  => array(
							'masonry',
							'small-masonry'
						)
					)
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_columns_number',
				'type'          => 'select',
				'label'         => esc_html__( 'Number of Columns', 'cevian-core' ),
				'default_value' => 'three',
				'description'   => esc_html__( 'Set number of columns for portfolio masonry type', 'cevian-core' ),
				'parent'        => $portfolio_masonry_container,
				'options'       => cevian_select_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) )
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_masonry_space_between_items',
				'type'          => 'select',
				'label'         => esc_html__( 'Space Between Items', 'cevian-core' ),
				'description'   => esc_html__( 'Set space size between columns for portfolio masonry type', 'cevian-core' ),
				'default_value' => 'normal',
				'options'       => cevian_select_get_space_between_items_array(),
				'parent'        => $portfolio_masonry_container
			)
		);
		
		/***************** Masonry Layout *****************/
		
		cevian_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'show_title_area_portfolio_single',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will show title area on single projects', 'cevian-core' ),
				'parent'        => $panel,
				'options'       => array(
					''    => esc_html__( 'Default', 'cevian-core' ),
					'yes' => esc_html__( 'Yes', 'cevian-core' ),
					'no'  => esc_html__( 'No', 'cevian-core' )
				),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_images',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Images', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for projects with images', 'cevian-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_lightbox_videos',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Lightbox for Videos', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will turn on lightbox functionality for YouTube/Vimeo projects', 'cevian-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_enable_categories',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Categories', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will enable category meta description on single projects', 'cevian-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_date',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Date', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will enable date meta on single projects', 'cevian-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_sticky_sidebar',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Sticky Side Text', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will make side text sticky on Single Project pages. This option works only for Full Width Images, Small Images, Small Gallery and Small Masonry portfolio types', 'cevian-core' ),
				'parent'        => $panel,
				'default_value' => 'yes'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_comments',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Show Comments', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will show comments on your page', 'cevian-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_hide_pagination',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Hide Pagination', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will turn off portfolio pagination functionality', 'cevian-core' ),
				'parent'        => $panel,
				'default_value' => 'no'
			)
		);
		
		$container_navigate_category = cevian_select_add_admin_container(
			array(
				'name'            => 'navigate_same_category_container',
				'parent'          => $panel,
				'dependency' => array(
					'hide' => array(
						'portfolio_single_hide_pagination'  => array(
							'yes'
						)
					)
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'          => 'portfolio_single_nav_same_category',
				'type'          => 'yesno',
				'label'         => esc_html__( 'Enable Pagination Through Same Category', 'cevian-core' ),
				'description'   => esc_html__( 'Enabling this option will make portfolio pagination sort through current category', 'cevian-core' ),
				'parent'        => $container_navigate_category,
				'default_value' => 'no'
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'name'        => 'portfolio_single_slug',
				'type'        => 'text',
				'label'       => esc_html__( 'Portfolio Single Slug', 'cevian-core' ),
				'description' => esc_html__( 'Enter if you wish to use a different Single Project slug (Note: After entering slug, navigate to Settings -> Permalinks and click "Save" in order for changes to take effect)', 'cevian-core' ),
				'parent'      => $panel,
				'args'        => array(
					'col_width' => 3
				)
			)
		);
	}
	
	add_action( 'cevian_select_action_options_map', 'cevian_select_portfolio_options_map', cevian_select_set_options_map_position( 'portfolio' ) );
}