<?php

if ( ! function_exists( 'cevian_core_map_testimonials_meta' ) ) {
	function cevian_core_map_testimonials_meta() {
		$testimonial_meta_box = cevian_select_create_meta_box(
			array(
				'scope' => array( 'testimonials' ),
				'title' => esc_html__( 'Testimonial', 'cevian-core' ),
				'name'  => 'testimonial_meta'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_testimonial_title',
				'type'        => 'text',
				'label'       => esc_html__( 'Title', 'cevian-core' ),
				'description' => esc_html__( 'Enter testimonial title', 'cevian-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_testimonial_text',
				'type'        => 'text',
				'label'       => esc_html__( 'Text', 'cevian-core' ),
				'description' => esc_html__( 'Enter testimonial text', 'cevian-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_testimonial_author',
				'type'        => 'text',
				'label'       => esc_html__( 'Author', 'cevian-core' ),
				'description' => esc_html__( 'Enter author name', 'cevian-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_testimonial_author_position',
				'type'        => 'text',
				'label'       => esc_html__( 'Author Position', 'cevian-core' ),
				'description' => esc_html__( 'Enter author job position', 'cevian-core' ),
				'parent'      => $testimonial_meta_box,
			)
		);
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_core_map_testimonials_meta', 95 );
}