(function($) {
    'use strict';

    var testimonialsVertical = {};
    qodef.modules.qodefInitTestimonialsVertical = qodefInitTestimonialsVertical;

    testimonialsVertical.qodefOnDocumentReady = qodefOnDocumentReady;

    $(document).ready(qodefOnDocumentReady);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function qodefOnDocumentReady() {
        qodefInitTestimonialsVertical();
    }

    /**
     * Initializes testimonials vertical logic
     */

    function qodefInitTestimonialsVertical() {
        var holders = $('.qodef-testimonials-holder');

        if(holders.length) {
            holders.each(function(){
                var holder = $(this),
                    swiperInstance = holder.find('.swiper-container'),
                    singleItem = holder.find('.qodef-testimonial-content'),
                    maxHeight = 0,
                    dataHolder = holder.find('.qodef-testimonials'),
                    loop = true,
                    delay = 5000,
                    speed = 300,
                    navigation = false,
                    pagination = false;

                var calcHeight = function() {
                    singleItem.each(function(){
                        var thisImgHeight = $(this).find('.qodef-testimonial-image').height();
                        var thisTextHeight = $(this).find('.qodef-testimonial-text-holder').height();
                        if (thisImgHeight > thisTextHeight) {
                            if(thisImgHeight > maxHeight) {
                                maxHeight = thisHeight;
                            }
                        } else {
                            if(thisTextHeight > maxHeight) {
                                maxHeight = thisTextHeight;
                            }
                        }
                    });

                    return maxHeight;
                }

                if( typeof(dataHolder.data('enable-loop')) !== 'undefined' && dataHolder.data('enable-loop') !== false ){
                    if(dataHolder.data('enable-loop') === 'no'){
                        loop = false;
                    }
                }

                if( typeof(dataHolder.data('slider-speed')) !== 'undefined' && dataHolder.data('slider-speed') !== false){
                    delay = dataHolder.data('slider-speed');
                }

                if( typeof(dataHolder.data('enable-autoplay')) !== 'undefined' && dataHolder.data('enable-autoplay') !== false){
                    if(dataHolder.data('enable-autoplay') === 'no'){
                        delay = 1000000;
                    }
                }

                if( typeof(dataHolder.data('slider-speed-animation')) !== 'undefined' && dataHolder.data('slider-speed-animation') !== false){
                    speed = dataHolder.data('slider-speed-animation');
                }

                if( dataHolder.data('enable-navigation') === 'yes'){
                    navigation = {
                        nextEl: holder.find('.swiper-button-next'),
                        prevEl: holder.find('.swiper-button-prev'),
                    };
                }
                if( dataHolder.data('enable-pagination') === 'yes'){
                    pagination = {
                        el: holder.find('.swiper-pagination'),
                        type: 'bullets',
                        clickable: true,
                    };
                }

                var swiperSlider = new Swiper (swiperInstance, {
                    loop: loop,
                    autoplay: {
                        delay: delay,
                    },
                    direction: 'vertical',
                    slidesPerView: 1,
                    speed: speed,
                    pagination: pagination,
                    navigation: navigation,
                    autoHeight: true,
                    index : 1,
                    bulletClass : 'swiper-pagination-bullet',
                    // slideToClickedSlide: true,
                    // Responsive breakpoints
                    // breakpoints: {
                    //     // when window width is <= 768px

                    //     768: {
                    //         slidesPerView: 1,
                    //     },
                    // },
                    init: false
                });

                swiperSlider.on('init', function(){
                    var imgHolders = holder.find('.qodef-testimonial-image');

                    imgHolders.eq(0).addClass('qodef-active');
                });

                swiperSlider.on('slideChange', function() {
                    var activeIndex = swiperSlider.realIndex,
                        imgHolders = holder.find('.qodef-testimonial-image');

                    imgHolders.removeClass('qodef-active');
                    imgHolders.eq(activeIndex).addClass('qodef-active');

                });

                swiperSlider.on('transitionEnd', function() {
                });


                holder.waitForImages(function() {
                    swiperSlider.init();
                });

                $(window).on('resize', function() {
                });


            });
        }

    }

})(jQuery);