(function($) {
	'use strict';
	
	var button = {};
	qodef.modules.button = button;
	
	button.qodefButton = qodefButton;
	button.qodefBtnSolidWithIcon = qodefBtnSolidWithIcon;
	button.qodefMinimalButton = qodefMinimalButton;

	
	button.qodefOnDocumentReady = qodefOnDocumentReady;
	
	$(document).ready(qodefOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
		qodefButton().init();
        qodefBtnSolidWithIcon();
        qodefMinimalButton();
	}
	
	/**
	 * Button object that initializes whole button functionality
	 * @type {Function}
	 */
	var qodefButton = function() {
		//all buttons on the page
		var buttons = $('.qodef-btn');
		
		/**
		 * Initializes button hover color
		 * @param button current button
		 */
		var buttonHoverColor = function(button) {
			if(typeof button.data('hover-color') !== 'undefined') {
				var changeButtonColor = function(event) {
					event.data.button.css('color', event.data.color);
				};
				
				var originalColor = button.css('color');
				var hoverColor = button.data('hover-color');
				
				button.on('mouseenter', { button: button, color: hoverColor }, changeButtonColor);
				button.on('mouseleave', { button: button, color: originalColor }, changeButtonColor);
			}
		};
		
		/**
		 * Initializes button hover background color
		 * @param button current button
		 */
		var buttonHoverBgColor = function(button) {
			if(typeof button.data('hover-bg-color') !== 'undefined') {
				var changeButtonBg = function(event) {
					event.data.button.css('background-color', event.data.color);
				};
				
				var originalBgColor = button.css('background-color');
				var hoverBgColor = button.data('hover-bg-color');
				
				button.on('mouseenter', { button: button, color: hoverBgColor }, changeButtonBg);
				button.on('mouseleave', { button: button, color: originalBgColor }, changeButtonBg);
			}
		};
		
		/**
		 * Initializes button border color
		 * @param button
		 */
		var buttonHoverBorderColor = function(button) {
			if(typeof button.data('hover-border-color') !== 'undefined') {
				var changeBorderColor = function(event) {
					event.data.button.css('border-color', event.data.color);
				};
				
				var originalBorderColor = button.css('borderTopColor'); //take one of the four sides
				var hoverBorderColor = button.data('hover-border-color');
				
				button.on('mouseenter', { button: button, color: hoverBorderColor }, changeBorderColor);
				button.on('mouseleave', { button: button, color: originalBorderColor }, changeBorderColor);
			}
		};
		
		return {
			init: function() {
				if(buttons.length) {
					buttons.each(function() {
						buttonHoverColor($(this));
						buttonHoverBgColor($(this));
						buttonHoverBorderColor($(this));
					});
				}
			}
		};
	};

    function qodefBtnSolidWithIcon() {
        var btns = $('.qodef-btn.qodef-btn-icon');

        if (btns.length) {
            btns.each(function(){
                if(! $(this).hasClass('qodef-btn-simple') && ! $(this).hasClass('qodef-btn-minimal')) {
                    var btn = $(this),
                        btnText = btn.find('.qodef-btn-text'),
                        btnIcon = btnText.next(),
                        delta = Math.floor(parseInt(btnIcon.css('margin-left')) + btnIcon.outerWidth() / 2);

                    btn.mouseenter(function () {
                        btnText.css({'transform': 'translate3d(' + delta + 'px, 0px, 0px)'});
                        btnIcon.css({
                            'transform': 'translate3d(' + delta + 'px, 0px, 0px)',
                            'opacity': '0'
                        });
                    });

                    btn.mouseleave(function () {
                        btnText.css({'transform': 'translate3d(0px, 0px, 0px)'});
                        btnIcon.css({
                            'transform': 'translate3d(0px, 0px, 0px)',
                            'opacity': '1'
                        });
                    });
                }
            });
        }
    }

    function qodefMinimalButton() {
        var button = $('.qodef-btn-minimal');

        button.each(function () {
            var text = $(this).find('.qodef-btn-text');
            var textWidth = text.width();
            var textIndent = text.width() * -1;
            var buttonInsideSlider = $('.rev_slider_wrapper .qodef-iwt .qodef-btn-minimal');
            var buttonOfset = 43;

            if(buttonInsideSlider.length){
            	buttonOfset = 123;
			}

            text.css('text-indent', textIndent);
            $(this).width(36);

            $(this).mouseenter(function () {
                $(this).width(textWidth + buttonOfset);
                text.css('text-indent', 29);
            });

            $(this).mouseleave(function () {
                $(this).width(36);
                text.css('text-indent', textIndent);
            });
        });

        setTimeout(function () {
            button.css('opacity', '1');
        }, 100);
    }
	
})(jQuery);