(function($) {
    'use strict';

    var charts = {};
    qodef.modules.charts = charts;

    charts.qodefInitCharts = qodefInitCharts;


    charts.qodefOnDocumentReady = qodefOnDocumentReady;

    $(document).ready(qodefOnDocumentReady);

    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function qodefOnDocumentReady() {
        qodefInitCharts();
    }

    // init charts shortcode
    function qodefInitCharts() {
        var chartHolder = $('.qodef-charts');

        if (chartHolder.length) {
            chartHolder.each(function () {
                var thisChartHolder = $(this);
                var thisChartCanvasId = thisChartHolder.find('canvas').attr('id');

                thisChartHolder.height(thisChartHolder.width() / 2);

                //////////////////////////////////////////////////////////////////////////////
                // prep vars from data atts

                var chartType = thisChartHolder.data('type');
                var noOfDatasets = thisChartHolder.data('no_of_used_datasets');
                var pointGroupLabels = thisChartHolder.data('point_group_labels');
                var colorScheme = '';
                var legendPosition = thisChartHolder.data('legend_position');
                var startAtZero = '';

                if (chartType == 'line' || chartType == 'horizontalBar' || chartType == 'bar') {
                    startAtZero = {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }],
                        xAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    };
                }

                //////////////////////////////////////////////////////////////////////////////

                var pointGroupColors = '',
                    dataset_1,
                    dataset_1_color,
                    dataset_2,
                    dataset_2_color,
                    dataset_3,
                    dataset_3_color,
                    datasets,
                    borderColor;

                if( typeof thisChartHolder.data('border_color') !== 'undefined' && thisChartHolder.data('border_color') !== '' ){
                    borderColor = thisChartHolder.data('border_color');
                } else{
                    borderColor = '#fff';
                }

                if (thisChartHolder.data('color_scheme') == 'dataset') {
                    dataset_1_color = thisChartHolder.data('dataset_1_color');
                }
                else {
                    dataset_1_color = thisChartHolder.data('point_group_colors').split(',');
                }

                dataset_1 = {
                    label: thisChartHolder.data('dataset_1_label'),
                    backgroundColor: dataset_1_color,
                    borderColor: borderColor,
                    data: thisChartHolder.data('dataset_1').split(','),
                    cubicInterpolationMode: 'monotone'
                };

                datasets = [dataset_1];

                if (noOfDatasets >= 2) {
                    if (thisChartHolder.data('color_scheme') == 'dataset') {
                        dataset_2_color = thisChartHolder.data('dataset_2_color');
                    }
                    else {
                        dataset_2_color = thisChartHolder.data('point_group_colors').split(',');
                    }

                    dataset_2 = {
                        label: thisChartHolder.data('dataset_2_label'),
                        backgroundColor: dataset_2_color,
                        borderColor: borderColor,
                        data: thisChartHolder.data('dataset_2').split(','),
                        cubicInterpolationMode: 'monotone'
                    };

                    datasets = [dataset_1, dataset_2];
                }

                if (noOfDatasets >= 3) {
                    if (thisChartHolder.data('color_scheme') == 'dataset') {
                        dataset_3_color = thisChartHolder.data('dataset_3_color');
                    }
                    else {
                        dataset_3_color = thisChartHolder.data('point_group_colors').split(',');
                    }

                    dataset_3 = {
                        label: thisChartHolder.data('dataset_3_label'),
                        backgroundColor: dataset_3_color,
                        borderColor: borderColor,
                        data: thisChartHolder.data('dataset_3').split(','),
                        cubicInterpolationMode: 'monotone'
                    };

                    datasets = [dataset_1, dataset_2, dataset_3];
                }

                // there is probably better way of doing init than the following one
                var thisChartParams = {
                    labels: pointGroupLabels.split(','),
                    datasets: datasets
                };

                //////////////////////////////////////////////////////////////////////////////

                var ctx = document.getElementById(thisChartCanvasId).getContext('2d');


                thisChartHolder.appear(function () {
                    thisChartHolder.addClass('qodef-appeared');

                    setTimeout(function () {

                        window.myBar = new Chart(ctx, {
                            type: chartType,
                            data: thisChartParams,
                            options: {
                                responsive: true,
                                legend: {
                                    position: legendPosition,
                                },
                                scales: startAtZero,
                            },
                        });


                    }, 500);
                }, {accX: 0, accY: qodefGlobalVars.vars.qodefElementAppearAmount});


            });
        }
    }

})(jQuery);