<?php
namespace CevianCore\CPT\Shortcodes\ElementsHolder;

use CevianCore\Lib;

class ElementsHolderItem implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'qodef_elements_holder_item';
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'                    => esc_html__( 'Elements Holder Item', 'cevian-core' ),
					'base'                    => $this->base,
					'as_child'                => array( 'only' => 'qodef_elements_holder' ),
					'as_parent'               => array( 'except' => 'vc_row, vc_accordion' ),
					'content_element'         => true,
					'category'                => esc_html__( 'by CEVIAN', 'cevian-core' ),
					'icon'                    => 'icon-wpb-elements-holder-item extended-custom-icon',
					'show_settings_on_create' => true,
					'js_view'                 => 'VcColumnView',
					'params'                  => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'cevian-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'cevian-core' )
						),
						array(
							'type'       => 'colorpicker',
							'param_name' => 'background_color',
							'heading'    => esc_html__( 'Background Color', 'cevian-core' )
						),
						array(
							'type'       => 'attach_image',
							'param_name' => 'background_image',
							'heading'    => esc_html__( 'Background Image', 'cevian-core' )
						),
						array(
                            'type'        => 'textfield',
                            'param_name'  => 'item_title',
                            'heading'     => esc_html__( 'Elements Holder Item Title', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'item_title_tag',
                            'heading'     => esc_html__( 'Title Tag', 'cevian-core' ),
                            'value'       => array_flip(cevian_select_get_title_tag(false)),
                            'dependency'  => array('element' => 'item_title', 'not_empty' => true)
                        ),
                        array(
                            'type'        => 'colorpicker',
                            'param_name'  => 'item_title_color',
                            'heading'     => esc_html__( 'Title Color', 'cevian-core' ),
                            'dependency'  => array('element' => 'item_title', 'not_empty' => true)
                        ),
                        array(
                            'type'        => 'colorpicker',
                            'param_name'  => 'item_title_border_color',
                            'heading'     => esc_html__( 'Title Bottom Border Color', 'cevian-core' ),
                            'dependency'  => array('element' => 'item_title', 'not_empty' => true)
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'title_padding',
                            'heading'     => esc_html__( 'Title Padding', 'cevian-core' ),
                            'dependency'  => array('element' => 'item_title', 'not_empty' => true)
                        ),
						array(
							'type'        => 'textfield',
							'param_name'  => 'item_padding',
							'heading'     => esc_html__( 'Padding', 'cevian-core' ),
							'description' => esc_html__( 'Please insert padding in format 0px 10px 0px 10px', 'cevian-core' )
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'horizontal_alignment',
							'heading'    => esc_html__( 'Horizontal Alignment', 'cevian-core' ),
							'value'      => array(
								esc_html__( 'Left', 'cevian-core' )   => 'left',
								esc_html__( 'Right', 'cevian-core' )  => 'right',
								esc_html__( 'Center', 'cevian-core' ) => 'center'
							)
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'vertical_alignment',
							'heading'    => esc_html__( 'Vertical Alignment', 'cevian-core' ),
							'value'      => array(
								esc_html__( 'Middle', 'cevian-core' ) => 'middle',
								esc_html__( 'Top', 'cevian-core' )    => 'top',
								esc_html__( 'Bottom', 'cevian-core' ) => 'bottom'
							)
						),
						array(
							'type'       => 'dropdown',
							'param_name' => 'animation',
							'heading'    => esc_html__( 'Animation Type', 'cevian-core' ),
							'value'      => array(
								esc_html__( 'Default (No Animation)', 'cevian-core' )   => '',
								esc_html__( 'Element Grow In', 'cevian-core' )          => 'qodef-grow-in',
								esc_html__( 'Element Fade In Down', 'cevian-core' )     => 'qodef-fade-in-down',
								esc_html__( 'Element From Fade', 'cevian-core' )        => 'qodef-element-from-fade',
								esc_html__( 'Element From Left', 'cevian-core' )        => 'qodef-element-from-left',
								esc_html__( 'Element From Right', 'cevian-core' )       => 'qodef-element-from-right',
								esc_html__( 'Element From Top', 'cevian-core' )         => 'qodef-element-from-top',
								esc_html__( 'Element From Bottom', 'cevian-core' )      => 'qodef-element-from-bottom',
								esc_html__( 'Element Flip In', 'cevian-core' )          => 'qodef-flip-in',
								esc_html__( 'Element X Rotate', 'cevian-core' )         => 'qodef-x-rotate',
								esc_html__( 'Element Z Rotate', 'cevian-core' )         => 'qodef-z-rotate',
								esc_html__( 'Element Y Translate', 'cevian-core' )      => 'qodef-y-translate',
								esc_html__( 'Element Fade In X Rotate', 'cevian-core' ) => 'qodef-fade-in-left-x-rotate',
							)
						),
						array(
							'type'       => 'textfield',
							'param_name' => 'animation_delay',
							'heading'    => esc_html__( 'Animation Delay (ms)', 'cevian-core' )
						),
                        array(
                            //!!! Updated media query value range from 1367-1600 to 1400-1600 without updating param name to preserve saved values
							'type'        => 'textfield',
							'param_name'  => 'item_padding_1367_1600',
                            'heading'     => esc_html__( 'Padding on screen size between 1400px-1600px', 'cevian-core' ),
							'description' => esc_html__( 'Please insert padding in format top right bottom left. For example 10px 0 10px 0', 'cevian-core' ),
							'group'       => esc_html__( 'Width & Responsiveness', 'cevian-core' )
						),
						array(
                            //!!! Updated media query value range from 1025-1366 to 1025-1399 without updating param name to preserve saved values
							'type'        => 'textfield',
							'param_name'  => 'item_padding_1025_1366',
							'heading'     => esc_html__( 'Padding on screen size between 1025px-1399px', 'cevian-core' ),
							'description' => esc_html__( 'Please insert padding in format top right bottom left. For example 10px 0 10px 0', 'cevian-core' ),
							'group'       => esc_html__( 'Width & Responsiveness', 'cevian-core' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'item_padding_769_1024',
							'heading'     => esc_html__( 'Padding on screen size between 768px-1024px', 'cevian-core' ),
							'description' => esc_html__( 'Please insert padding in format 0px 10px 0px 10px', 'cevian-core' ),
							'group'       => esc_html__( 'Width & Responsiveness', 'cevian-core' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'item_padding_681_768',
							'heading'     => esc_html__( 'Padding on screen size between 680px-768px', 'cevian-core' ),
							'description' => esc_html__( 'Please insert padding in format 0px 10px 0px 10px', 'cevian-core' ),
							'group'       => esc_html__( 'Width & Responsiveness', 'cevian-core' )
						),
						array(
							'type'        => 'textfield',
							'param_name'  => 'item_padding_680',
							'heading'     => esc_html__( 'Padding on screen size bellow 680px', 'cevian-core' ),
							'description' => esc_html__( 'Please insert padding in format 0px 10px 0px 10px', 'cevian-core' ),
							'group'       => esc_html__( 'Width & Responsiveness', 'cevian-core' )
						),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'title_padding_1367_1600',
                            'heading'     => esc_html__( 'Title Padding on screen size between 1367px-1600px', 'cevian-core' ),
                            'description' => esc_html__( 'Please insert padding in format top right bottom left. For example 10px 0 10px 0', 'cevian-core' ),
                            'group'       => esc_html__( 'Title Width & Responsiveness', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'title_padding_1025_1366',
                            'heading'     => esc_html__( 'Title Padding on screen size between 1025px-1366px', 'cevian-core' ),
                            'description' => esc_html__( 'Please insert padding in format top right bottom left. For example 10px 0 10px 0', 'cevian-core' ),
                            'group'       => esc_html__( 'Title Width & Responsiveness', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'title_padding_769_1024',
                            'heading'     => esc_html__( 'Title Padding on screen size between 768px-1024px', 'cevian-core' ),
                            'description' => esc_html__( 'Please insert padding in format 0px 10px 0px 10px', 'cevian-core' ),
                            'group'       => esc_html__( 'Title Width & Responsiveness', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'title_padding_681_768',
                            'heading'     => esc_html__( 'Title Padding on screen size between 680px-768px', 'cevian-core' ),
                            'description' => esc_html__( 'Please insert padding in format 0px 10px 0px 10px', 'cevian-core' ),
                            'group'       => esc_html__( 'Title Width & Responsiveness', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'textfield',
                            'param_name'  => 'title_padding_680',
                            'heading'     => esc_html__( 'Title Padding on screen size bellow 680px', 'cevian-core' ),
                            'description' => esc_html__( 'Please insert padding in format 0px 10px 0px 10px', 'cevian-core' ),
                            'group'       => esc_html__( 'Title Width & Responsiveness', 'cevian-core' )
                        )
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'           => '',
			'background_color'       => '',
			'background_image'       => '',
			'item_title'             => '',
			'item_title_tag'         => 'h5',
			'item_title_color'       => '',
			'item_title_border_color'=> '',
			'title_padding'          => '',
			'item_padding'           => '',
			'horizontal_alignment'   => '',
			'vertical_alignment'     => '',
			'animation'              => '',
			'animation_delay'        => '',
			'item_padding_1367_1600' => '',
			'item_padding_1025_1366' => '',
			'item_padding_769_1024'  => '',
			'item_padding_681_768'   => '',
			'item_padding_680'       => '',
            'title_padding_1367_1600'=> '',
            'title_padding_1025_1366'=> '',
            'title_padding_769_1024' => '',
            'title_padding_681_768'  => '',
            'title_padding_680'      => ''
		);
		$params = shortcode_atts( $args, $atts );
		
		$params['content']           = $content;
		$params['holder_classes']    = $this->getHolderClasses( $params );
		$params['holder_rand_class'] = 'qodef-eh-custom-' . mt_rand( 1000, 10000 );
		$params['holder_styles']     = $this->getHolderStyles( $params );
		$params['content_styles']    = $this->getContentStyles( $params );
		$params['holder_data']       = $this->getHolderData( $params );
        $params['title_rand_class']  = 'qodef-eh-title-' . mt_rand( 1000, 10000 );
		$params['title_styles']      = $this->getTitleStyles( $params );
		$params['title_holder_styles']= $this->getTitleHolderStyles( $params );
        $params['title_holder_data']  = $this->getTItleHolderData( $params );

		$html = cevian_core_get_shortcode_module_template_part( 'templates/elements-holder-item-template', 'elements-holder', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['vertical_alignment'] ) ? 'qodef-vertical-alignment-' . $params['vertical_alignment'] : '';
		$holderClasses[] = ! empty( $params['horizontal_alignment'] ) ? 'qodef-horizontal-alignment-' . $params['horizontal_alignment'] : '';
		$holderClasses[] = ! empty( $params['animation'] ) ? $params['animation'] : '';
		$holderClasses[] = ! empty( $params['item_title'] ) ? 'qodef-eh-with-title' : '';

		return implode( ' ', $holderClasses );
	}
	
	private function getHolderStyles( $params ) {
		$styles = array();
		
		if ( ! empty( $params['background_color'] ) ) {
			$styles[] = 'background-color: ' . $params['background_color'];
		}
		
		if ( ! empty( $params['background_image'] ) ) {
			$styles[] = 'background-image: url(' . wp_get_attachment_url( $params['background_image'] ) . ')';
		}
		
		return implode( ';', $styles );
	}
	
	private function getContentStyles( $params ) {
		$styles = array();
		
		if ( $params['item_padding'] !== '' ) {
			$styles[] = 'padding: ' . $params['item_padding'];
		}
		
		return implode( ';', $styles );
	}
	
	private function getHolderData( $params ) {
		$data                    = array();
		$data['data-item-class'] = $params['holder_rand_class'];
		
		if ( ! empty( $params['animation'] ) ) {
			$data['data-animation'] = $params['animation'];
		}
		
		if ( $params['animation_delay'] !== '' ) {
			$data['data-animation-delay'] = esc_attr( $params['animation_delay'] );
		}

		if ( $params['item_padding_1367_1600'] !== '' ) {
			$data['data-1367-1600'] = $params['item_padding_1367_1600'];
		}
		
		if ( $params['item_padding_1025_1366'] !== '' ) {
			$data['data-1025-1366'] = $params['item_padding_1025_1366'];
		}
		
		if ( $params['item_padding_769_1024'] !== '' ) {
			$data['data-769-1024'] = $params['item_padding_769_1024'];
		}
		
		if ( $params['item_padding_681_768'] !== '' ) {
			$data['data-681-768'] = $params['item_padding_681_768'];
		}
		
		if ( $params['item_padding_680'] !== '' ) {
			$data['data-680'] = $params['item_padding_680'];
		}
		
		return $data;
	}

    private function getTitleHolderData( $params ) {
        $data                    = array();
        $data['data-title-class'] = $params['title_rand_class'];

        if ( $params['title_padding_1367_1600'] !== '' ) {
            $data['data-1367-1600'] = $params['title_padding_1367_1600'];
        }

        if ( $params['title_padding_1025_1366'] !== '' ) {
            $data['data-1025-1366'] = $params['title_padding_1025_1366'];
        }

        if ( $params['title_padding_769_1024'] !== '' ) {
            $data['data-769-1024'] = $params['title_padding_769_1024'];
        }

        if ( $params['title_padding_681_768'] !== '' ) {
            $data['data-681-768'] = $params['title_padding_681_768'];
        }

        if ( $params['title_padding_680'] !== '' ) {
            $data['data-680'] = $params['title_padding_680'];
        }

        return $data;
    }

	private function getTitleStyles( $params ){
        $styles = array();

        if ( $params['item_title_color'] !== '' ) {
            $styles[] = 'color: ' . $params['item_title_color'];
        }

        return implode( ';', $styles );
    }

    private function getTitleHolderStyles( $params ){
        $styles = array();

        if ( $params['item_title_border_color'] !== '' ) {
            $styles[] = 'border-bottom-color: ' . $params['item_title_border_color'];
        }

        if ( $params['title_padding'] !== '' ) {
            $styles[] = 'padding: ' . $params['title_padding'];
        }

        return implode( ';', $styles );
    }
}
