(function($) {
    'use strict';
    
    var frameVideo = {};
    qodef.modules.frameVideo = frameVideo;
    
    frameVideo.qodefFVAppearfx = qodefFVAppearfx;
    frameVideo.qodefOnDocumentReady = qodefOnDocumentReady;
    
    $(document).ready(qodefOnDocumentReady);
    
    /*
     All functions to be called on $(document).ready() should be in this function
     */
    function qodefOnDocumentReady() {
        qodefFVAppearfx();
        qodefInitPlayFuncionality();
    }

    function qodefInitPlayFuncionality(){
        var fsv = $('.qodef-frame-video-holder');

        if(fsv.length){
            fsv.each(function(){
                var thisFsv = $(this),
                    playButton = thisFsv.find('.qodef-fv-control-button'),
                    video = thisFsv.find('.qodef-fv-video'),
                    videoControls = video[0],
                    gif = thisFsv.find('.qodef-fv-gif');


                //video play/pause logic
                if(video.length) {
                    playButton.on("click", function () {
                        if (videoControls.paused === true) {
                            // Play the video
                            videoControls.play();

                            playButton.addClass('qodef-fv-playing');
                        } else {
                            // Pause the video
                            videoControls.pause();

                            playButton.removeClass('qodef-fv-playing');
                        }
                    });
                }

                //gif play/pause logic
                if(gif.length){
                    var gifSrc = gif.data("gif"),
                        imgSrc = gif.attr("src");
                    playButton.on("click", function () {
                        if( ! playButton.hasClass('qodef-fv-playing') ){
                            gif.attr("src", gifSrc);
                            playButton.addClass('qodef-fv-playing');
                        } else{
                            gif.attr("src", imgSrc);
                            playButton.removeClass('qodef-fv-playing');
                        }

                        // function()
                        // {
                        //     var src = $(this).attr("src");
                        //     $(this).attr("src", src.replace(/\.png$/i, ".gif"));
                        // },
                        // function()
                        // {
                        //     var src = $(this).attr("src");
                        //     $(this).attr("src", src.replace(/\.gif$/i, ".png"));
                        // });
                    });
                }
            });
        }
    }

    function qodefFVAppearfx() {
        var fvs = $('.qodef-frame-video-holder');

        if (fvs.length && !qodef.htmlEl.hasClass('touch')) {
            fvs.appear(function(){
                $(this).addClass('qodef-appeared');
           }, {accX: 0, accY: qodefGlobalVars.vars.qodefElementAppearAmount});
        }
    }
})(jQuery);