<?php
namespace CevianCore\CPT\Shortcodes\FrameVideo;

use CevianCore\Lib;

class FrameVideo implements Lib\ShortcodeInterface {
    private $base;

    public function __construct() {
        $this->base = 'cevian_frame_video';

        add_action('vc_before_init', array($this, 'vcMap'));
    }

    /**
     * Returns base for shortcode
     * @return string
     */
    public function getBase() {
        return $this->base;
    }

    /**
     * Maps shortcode to Visual Composer. Hooked on vc_before_init
     */
    public function vcMap() {
        vc_map(array(
            'name'                      => esc_html__('Frame Video', 'cevian-core'),
            'base'                      => $this->getBase(),
            'category'                  => esc_html__('by CEVIAN', 'cevian-core'),
            'icon'                      => 'icon-wpb-frame-video extended-custom-icon',
            'allowed_container_element' => 'vc_row',
            'params'                    => array(
                array(
                    'type'       => 'dropdown',
                    'param_name' => 'video_source',
                    'heading'    => esc_html__('Video Source', 'cevian-core'),
                    'value'      => array(
                        esc_html__('Video', 'cevian-core') => 'video',
                        esc_html__('Gif', 'cevian-core') => 'gif'
                    ),
                    'save_always' => 'true'
                ),
	            array(
		            'type'       => 'textfield',
		            'param_name' => 'video_link',
		            'heading'    => esc_html__('Video Link', 'cevian-core'),
                    'dependency' => array('element' => 'video_source', 'value' => 'video')
	            ),
                array(
		            'type'       => 'attach_image',
		            'param_name' => 'gif_link',
		            'heading'    => esc_html__('Gif Image', 'cevian-core'),
                    'dependency' => array('element' => 'video_source', 'value' => 'gif')
	            ),
                array(
		            'type'       => 'attach_image',
		            'param_name' => 'gif_preload_image',
		            'heading'    => esc_html__('Gif Preload Image', 'cevian-core'),
                    'dependency' => array('element' => 'video_source', 'value' => 'gif')
	            )
            )
        ));
    }
	
	/**
	 * Renders shortcodes HTML
	 *
	 * @param $atts array of shortcode params
	 *
	 * @return string
	 */
	public function render($atts, $content = null) {
		$args = array(
		    'video_source'  => '',
			'video_link'         => '#',
            'gif_link' => '',
            'gif_preload_image' => ''
		);
		
		$params = shortcode_atts($args, $atts);

		//Get HTML from template
		$html = cevian_core_get_shortcode_module_template_part('templates/frame-video', 'frame-video', '', $params);
		
		return $html;
	}
}