<?php

namespace CevianCore\CPT\Shortcodes\IconShowcase;

use CevianCore\Lib;

class IconShowcaseItem implements Lib\ShortcodeInterface {
    private $base;

    function __construct() {
        $this->base = 'qodef_icon_showcase_item';

        add_action( 'vc_before_init', array( $this, 'vcMap' ) );
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if ( function_exists( 'vc_map' ) ) {
            vc_map(
                array(
                    'name'            => esc_html__( 'Items Showcase Item', 'cevian-core' ),
                    'base'            => $this->base,
                    'category'        => esc_html__( 'by CEVIAN', 'cevian-core' ),
                    'icon'            => 'icon-wpb-icon-showcase-item extended-custom-icon',
                    'as_child' => array('only' => 'qodef_icon_showcase'),
                    'show_settings_on_create' => true,
                    'params' => array(
                        array(
                            'type' => 'textfield',
                            'class' => '',
                            'heading'    => esc_html__( 'Subtitle', 'cevian-core' ),
                            'param_name' => 'subtitle',
                            'value' => '',
                            'description' => ''
                        ),
                        array(
                            'type' => 'colorpicker',
                            'class' => '',
                            'heading'    => esc_html__( 'Subtitle Color', 'cevian-core' ),
                            'param_name' => 'subtitle_color',
                            'value' => '',
                            'description' => '',
                            'dependency' => array('element' => 'subtitle', 'not_empty' => true)
                        ),
                        array(
                            'type' => 'textfield',
                            'class' => '',
                            'heading'    => esc_html__( 'Title', 'cevian-core' ),
                            'param_name' => 'title',
                            'value' => '',
                            'description' => ''
                        ),
                        array(
                            'type'       => 'dropdown',
                            'heading'    => esc_html__( 'Title Tag', 'cevian-core' ),
                            'param_name' => 'title_tag',
                            'value'      => array_flip( cevian_select_get_title_tag( true, array( 'p' => 'p' ) ) ),
                            'dependency' => array('element' => 'title', 'not_empty' => true)
                        ),
                        array(
                            'type' => 'textfield',
                            'class' => '',
                            'heading'    => esc_html__( 'Responsive Title', 'cevian-core' ),
                            'param_name' => 'responsive_title',
                            'value' => '',
                            'description' => ''
                        ),
                        array(
                            'type'       => 'dropdown',
                            'heading'    => esc_html__( 'Responsive Title Tag', 'cevian-core' ),
                            'param_name' => 'responsive_title_tag',
                            'value'      => array_flip( cevian_select_get_title_tag( true, array( 'p' => 'p' ) ) ),
                            'dependency' => array('element' => 'responsive_title', 'not_empty' => true)
                        ),
                        array(
                            'type' => 'textarea_html',
                            'class' => '',
                            'heading'    => esc_html__( 'Content', 'cevian-core' ),
                            'param_name' => 'content',
                            'value' => ''
                        )
                    )
                )
            );
        }
    }

    public function render( $atts, $content = null ) {
        $args = array(
            'subtitle' => '',
            'subtitle_color' => '',
            'title' => '',
            'title_tag' => 'h4',
            'responsive_title' => '',
            'responsive_title_tag' => 'h4'
        );
        $args = array_merge($args, cevian_select_icon_collections()->getShortcodeParams());
        $params = shortcode_atts($args, $atts);
        extract($params);

        if($params['icon_pack']) {
            $iconPackName = cevian_select_icon_collections()->getIconCollectionParamNameByKey($params['icon_pack']);
            $params['icon'] = $params[$iconPackName];
        }

        $params['content'] = $content;
        $params['subtitle_style'] = $this->getSubtitleColor($params);
        $params['showcase_item_class'] = $this->getShowcaseItemClasses($params);

        $html = cevian_core_get_shortcode_module_template_part( 'templates/icon-showcase-item', 'icon-showcase', '', $params );

        return $html;
    }

    private function getShowcaseItemClasses($params){
        $itemClass = array();

        $itemClass[] = ! empty( $params['custom_hover_icon'] ) ? 'qodef-isi-has-hover-icon' : '';

        return implode(' ', $itemClass);
    }

    private function getSubtitleColor($params) {
        $style = array();

        if(!empty($params['subtitle_color'])){
            $style[] = 'color: ' . $params['subtitle_color'];
        }

        return $style;
    }
    private function getIconBackgroundColor($params) {
        $style = array();

        if(!empty($params['icon_background_color'])){
            $style[] = 'background-color: ' . $params['icon_background_color'];
        }

        return $style;
    }
}