<?php
namespace CevianCore\CPT\Shortcodes\IconShowcase;

use CevianCore\Lib;

class IconShowcase implements Lib\ShortcodeInterface {
    private $base;

    function __construct() {
        $this->base = 'qodef_icon_showcase';

        add_action( 'vc_before_init', array( $this, 'vcMap' ) );
    }

    public function getBase() {
        return $this->base;
    }

    public function vcMap() {
        if ( function_exists( 'vc_map' ) ) {
            vc_map(
                array(
                    'name'                    => esc_html__( 'Items Showcase', 'cevian-core' ),
                    'base'                    => $this->base,
                    'category'                => esc_html__( 'by CEVIAN', 'cevian-core' ),
                    'icon'                    => 'icon-wpb-icon-showcase extended-custom-icon',
                    'as_parent'               => array( 'only' => 'qodef_icon_showcase_item' ),
                    'js_view'                 => 'VcColumnView',
                    'show_settings_on_create' => true,
                    'params'                  => array(
                        array(
                            'type' => 'dropdown',
                            'admin_label' => true,
                            'heading'    => esc_html__( 'Autoplay', 'cevian-core' ),
                            'param_name' => 'autoplay',
                            'value' => array(
                                'Yes' => 'yes',
                                'No' => 'no'
                            ),
                            'save_always' => true,
                            'description' => ''
                        ),
                        array(
                            'type' => 'textfield',
                            'admin_label' => true,
                            'heading'    => esc_html__( 'Autoplay Interval (ms)', 'cevian-core' ),
                            'param_name' => 'autoplay_interval',
                            'save_always' => true,
                            'description'    => esc_html__( 'Default value is 3000.', 'cevian-core' ),
                        ),
                       
                    )
                )
            );
        }
    }

    /**
     * Renders HTML for product list shortcode
     *
     * @param array $atts
     * @param null  $content
     *
     * @return string
     */
    public function render( $atts, $content = null ) {
        $args   = array(
            'autoplay' => 'yes',
            'autoplay_interval' => '3000',
        );
        $params = shortcode_atts( $args, $atts );

        $icon_showcase_classes = array();
        $icon_showcase_classes[] = 'qodef-int-icon-showcase';
        if ($params['autoplay'] == 'yes') {
            $icon_showcase_classes[] = 'qodef-autoplay';
        }

        $icon_showcase_class = implode(' ', $icon_showcase_classes);

        $data_attr = $this->getDataAttr($params);


        $html = '';

        $html .= '<div '. cevian_select_get_class_attribute($icon_showcase_class) . cevian_select_get_inline_attrs($data_attr) . '>';
        $html .= '<div class="qodef-int-icon-showcase-inner">';
        $html .= do_shortcode($content);
        $html .= '</div>';
        $html .= '<div class="qodef-int-icon-circle"></div>';
        $html .= '</div>';

        return $html;

    }

    /**
     *
     * Returns array of data attr
     *
     * @param $params
     *
     * @return array
     */
    private function getDataAttr($params) {
        $data_attr = array();

        if(!empty($params['autoplay_interval'])) {
            $data_attr['data-interval'] = $params['autoplay_interval'];
        }

        return $data_attr;
    }

}