<?php
namespace CevianCore\CPT\Shortcodes\Process;

use CevianCore\Lib;

class Process implements Lib\ShortcodeInterface {
	private $base;
	
	function __construct() {
		$this->base = 'qodef_process';
		add_action( 'vc_before_init', array( $this, 'vcMap' ) );
	}
	
	public function getBase() {
		return $this->base;
	}
	
	public function vcMap() {
		if ( function_exists( 'vc_map' ) ) {
			vc_map(
				array(
					'name'            => esc_html__( 'Process', 'cevian-core' ),
					'base'            => $this->base,
					'icon'            => 'icon-wpb-process extended-custom-icon',
					'category'        => esc_html__( 'by CEVIAN', 'cevian-core' ),
					'as_parent'       => array( 'only' => 'qodef_process_item' ),
					'content_element' => true,
					'js_view'         => 'VcColumnView',
					'params'          => array(
						array(
							'type'        => 'textfield',
							'param_name'  => 'custom_class',
							'heading'     => esc_html__( 'Custom CSS Class', 'cevian-core' ),
							'description' => esc_html__( 'Style particular content element differently - add a class name and refer to it in custom CSS', 'cevian-core' )
						),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'number_of_columns',
							'heading'     => esc_html__( 'Number Of Columns', 'cevian-core' ),
							'value'       => array_flip( cevian_select_get_number_of_columns_array( false, array( 'one', 'five', 'six' ) ) ),
							'save_always' => true
						),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'type',
                            'heading'     => esc_html__( 'Type', 'cevian-core' ),
                            'value'       => array(
                                esc_html__( 'Horizontal', 'cevian-core' ) => 'horizontal',
                                esc_html__( 'Vertical', 'cevian-core' )    => 'vertical'
                            )
                        ),
                        array(
                            'type'       => 'dropdown',
                            'param_name' => 'boxed',
                            'heading'    => esc_html__( 'Boxed', 'cevian-core' ),
                            'value'      => array_flip( cevian_select_get_yes_no_select_array(false) ),
                            'dependency' => array( 'element' => 'type', 'value' => 'horizontal' )
                        ),
                        array(
                            'type'        => 'colorpicker',
                            'param_name'  => 'process_number_color',
                            'heading'     => esc_html__( 'Proces number color', 'cevian-core' )
                        ),
                        array(
                            'type'        => 'dropdown',
                            'param_name'  => 'skin',
                            'heading'     => esc_html__( 'Skin', 'cevian-core' ),
                            'value'       => array(
                                esc_html__( 'Default', 'cevian-core' ) => 'default',
                                esc_html__( 'Blue', 'cevian-core' )    => 'blue',
                                esc_html__( 'Gold', 'cevian-core' )    => 'gold'
                            ),
                            'dependency'  => array('element' => 'type', 'value' => 'vertical')
                        ),
						array(
							'type'        => 'dropdown',
							'param_name'  => 'switch_to_one_column',
							'heading'     => esc_html__( 'Switch to One Column', 'cevian-core' ),
							'value'       => array(
								esc_html__( 'Default None', 'cevian-core' ) => '',
								esc_html__( 'Below 1366px', 'cevian-core' ) => '1366',
								esc_html__( 'Below 1024px', 'cevian-core' ) => '1024',
								esc_html__( 'Below 768px', 'cevian-core' )  => '768',
								esc_html__( 'Below 680px', 'cevian-core' )  => '680',
								esc_html__( 'Below 480px', 'cevian-core' )  => '480'
							),
							'description' => esc_html__( 'Choose on which stage item will be in one column', 'cevian-core' ),
							'save_always' => true
						)
					)
				)
			);
		}
	}
	
	public function render( $atts, $content = null ) {
		$args   = array(
			'custom_class'         => '',
			'number_of_columns'    => 'three',
			'process_number_color' => '',
			'type'                 => 'horizontal',
			'boxed'                => 'no',
			'skin'                 => 'default',
			'switch_to_one_column' => ''
		);
		$params = shortcode_atts( $args, $atts );
		
		$params['holder_classes']       = $this->getHolderClasses( $params, $args );
		$params['number_of_items']      = $this->getNumberOfItems( $params['number_of_columns'] );
		$params['content']              = $content;
		$params['skin']                 = $this->getVerticalHolderSkin($params);
		$params['boxed']                = $this->getHorizontalHolderBoxed($params);
        $params['process_number_color'] = ! empty($params['process_number_color']) ? 'color: '.$params['process_number_color'] : '';

		$html = cevian_core_get_shortcode_module_template_part( 'templates/process-template', 'process', '', $params );
		
		return $html;
	}
	
	private function getHolderClasses( $params, $args ) {
		$holderClasses = array();
		
		$holderClasses[] = ! empty( $params['custom_class'] ) ? esc_attr( $params['custom_class'] ) : '';
		$holderClasses[] = ! empty( $params['number_of_columns'] ) ? 'qodef-' . $params['number_of_columns'] . '-columns' : 'qodef-' . $args['number_of_columns'] . '-columns';
		$holderClasses[] = ! empty( $params['switch_to_one_column'] ) ? 'qodef-responsive-' . $params['switch_to_one_column'] : '';
		
		return implode( ' ', $holderClasses );
	}
	
	private function getNumberOfItems( $params ) {
		$number = 3;
		
		switch ($params) {
			case 'two':
				$number = 2;
				break;
			case 'three':
				$number = 3;
				break;
			case 'four':
				$number = 4;
				break;
		}
		
		return $number;
	}

	private function getVerticalHolderSkin($params){

        $skin = 'qodef-process-'.$params['skin'].'-skin';

        return $skin;
    }

    private function getHorizontalHolderBoxed($params){

        if($params['boxed'] == 'yes') {
            $boxed = 'qodef-process-boxed';
        }else{
            $boxed = '';
        }

        return $boxed;
    }

    private function getTypeVisibility($type, $args) {

    }
}
