(function($) {
	'use strict';
	
	var tabs = {};
	qodef.modules.tabs = tabs;
	
	tabs.qodefInitTabs = qodefInitTabs;
	
	
	tabs.qodefOnDocumentReady = qodefOnDocumentReady;
	
	$(document).ready(qodefOnDocumentReady);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
		qodefInitTabs();
        qodefBottomLineFortabs();
	}
	
	/*
	 **	Init tabs shortcode
	 */
	function qodefInitTabs(){
		var tabs = $('.qodef-tabs');
		
		if(tabs.length){
			tabs.each(function(){
				var thisTabs = $(this);
				
				thisTabs.children('.qodef-tab-container').each(function(index){
					index = index + 1;
					var that = $(this),
						link = that.attr('id'),
						navItem = that.parent().find('.qodef-tabs-nav li:nth-child('+index+') a'),
						navLink = navItem.attr('href');
					
					link = '#'+link;

					if(link.indexOf(navLink) > -1) {
						navItem.attr('href',link);
					}
				});
				
				thisTabs.tabs();

                $('.qodef-tabs a.qodef-external-link').unbind('click');
			});
		}
	}
    function qodefBottomLineFortabs() {
        var firstLevelMenus = $('.qodef-tabs-standard .qodef-tabs-nav');

        if (firstLevelMenus.length) {
            firstLevelMenus.each(function(){
                var mainMenu = $(this);

                mainMenu.append('<li class="qodef-tabs-line"></li>');

                var menuLine = mainMenu.find('.qodef-tabs-line'),
                    menuItems = mainMenu.find('> li:not(.qodef-tabs-line)'),
                    initialOffset;

                if (menuItems.filter('.ui-state-active').length) {
                    initialOffset = menuItems.filter('.ui-state-active').offset().left;
                        menuLine.css('width', menuItems.filter('.ui-state-active').outerWidth());
                } else {
                    initialOffset = menuItems.first().offset().left;
                    menuLine.css('width', menuItems.first().outerWidth());
                }

                //initial positioning
                menuLine.css('left',  initialOffset - mainMenu.offset().left);
                //menuLine.css('top',  Math.floor(menuItems.first().find('.item_text').offset().top - mainMenu.offset().top + menuItems.first().find('.item_text').height() + lineTopOffset));

                //fx on
                menuItems.mouseenter(function(){
                    var menuItem = $(this),
                        menuItemWidth = menuItem.outerWidth(),
                        mainMenuOffset = mainMenu.offset().left,
                        menuItemOffset = menuItem.offset().left - mainMenuOffset;

                    menuLine.css('width', menuItemWidth);
                    menuLine.css('left', menuItemOffset);
                });

                //fx off
                menuItems.mouseleave(function(){

                    var menuItem = $(this),
                        menuItemWidth = menuItem.outerWidth(),
                        mainMenuOffset = mainMenu.offset().left,
                        menuItemOffset = menuItem.offset().left - mainMenuOffset;

                    if(menuItem.hasClass('ui-state-active')){
                        menuLine.css('width', menuItemWidth);
                        menuLine.css('left', menuItemOffset);
                    } else{
                        var activeLi = menuItems.filter('.ui-state-active'),
                            activeWidth = activeLi.outerWidth(),
                            activeLeft = activeLi.offset().left - mainMenuOffset;

                        menuLine.css('width', activeWidth);
                        menuLine.css('left', activeLeft);
                    }
                });

            });
        }
    }
	
})(jQuery);