<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://gsoulinc.com
 * @since      1.0.0
 *
 * @package    GS_CRM
 * @subpackage GS_CRM/admin/partials
 */
require_once '../dompdf/autoload.inc.php';
use Dompdf\Dompdf;
global $wpdb;

if( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) &&  $_POST['action'] == "generate-one-sheet" && check_admin_referer( 'verify_generate_one_sheet', 'nonce_generate_one_sheet' )) { 
 
$my_postid = $_POST['postid'];
//Get the main content from the post
$content_post = get_post($my_postid);
$thecontent = $content_post->post_content;        
$thecontent = apply_filters('the_content', $thecontent);
$meta = get_post_meta($my_postid, '', true);
$account_name = get_the_title($my_postid);
$account_address2 = isset($meta["com_address2"][0])?'<div class="address">'.$meta["com_address2"][0].'</div>':'';
$billing_address2 = isset($meta["billing_address2"][0])?'<div class="address">'.$meta["billing_address2"][0].'</div>':'';
$mailto = "";
if($meta["billing_diff"][0]==1){
	$mailto = '<h2 class="name">'.$account_name.'</h2>
			<div class="address">'.$meta["billing_address"][0].' '.$billing_address2.'</div>
			<div class="address">'.$meta["billing_city"][0].', '.$meta["billing_state"][0].' '.$meta["billing_zip"][0].'</div>';
}else{
	$mailto = '<h2 class="name">'.$account_name.'</h2>
			<div class="address">'.$meta["com_address"][0].' '.$account_address2.'</div>
			<div class="address">'.$meta["com_city"][0].', '.$meta["com_state"][0].' '.$meta["com_zip"][0].'</div>';
}

$tablename = $wpdb->prefix.'gs_billing';
$get_billing = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM ' .$tablename. ' WHERE `billing_account` = "'.$meta["signal_number"][0].'" ORDER BY id DESC LIMIT 1'));
$invoice_num 	= "";
$invoice_acc 	= "";
$invoice_date 	= "";
$invoice_method = "";
$invoice_term 	= "";
$invoice_amount = "";
$invoice_tax	= "";
$invoice_period = "";
foreach ( $get_billing as $billing_result )
{
	$invoice_num 	= $billing_result->billing_id;
	$invoice_acc 	= $billing_result->billing_account;
	$invoice_date 	= date("m/d/Y", strtotime($billing_result->billing_created));
	$invoice_method = $billing_result->billing_method;
	$invoice_note 	= $billing_result->billing_note;
	$invoice_term 	= $billing_result->billing_term;
	$invoice_amount = number_format($billing_result->billing_amount, 2,'.', ',');
	$invoice_tax	= $billing_result->billing_tax;
	$invoice_total	= $billing_result->billing_total;
	$invoice_period = $billing_result->billing_period;
}

//print_r($meta);
$billing_due 	= date("m/d/Y", strtotime($meta["billing_date"][0]));
//$billing_period = date("m/d/Y", strtotime($meta["billing_date"][0])).'~'.date("m/d/Y", strtotime($meta["billing_date"][0]. " + '.$invoice_term.' months"));
$sub_total 		= number_format($invoice_amount*$invoice_term, 2,'.', ',');
$tax_rate		= number_format(($invoice_tax/100), 5,'.', ',');
$tax_amount		= number_format(($invoice_amount*$invoice_term*$tax_rate), 2,'.', ',');
$grand_total 	= number_format($sub_total + $tax_amount, 2,'.', ',');;

//* Billing invoice header Start */
$billing_header = '
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<title></title>
		<link rel="stylesheet" href="'.get_theme_file_uri("pdf-style.css").'" media="all" />
	</head>
	<body>
	<header class="clearfix">
		<div id="logo"><img src="'.get_theme_file_uri("sunworld-favicon.png").'"></div>
		<div id="company">
			<h2 class="name">Sun World Security Inc.</h2>
			<div>156-07 45th Ave, Flushing, NY 11355</div>
			<div>(347) 732 - 0101 / Fax (917) 563 - 1762</div>
			<div><a href="mailto:nysunworld@gmail.com">nysunworld@gmail.com</a></div>
		</div>
    </header>';
	
$billing_body = '	<main>
		<div id="mail-section" class="clearfix">
			<div id="details" class="clearfix">
				<div id="client">
					<div class="to">INVOICE TO:</div>
					<h2 class="name">'.$account_name.'</h2>
					<div class="address">'.$meta["com_address"][0].' '.$address2.'</div>
					<div class="address">'.$meta["com_city"][0].', '.$meta["com_state"][0].' '.$meta["com_zip"][0].'</div>
				</div>
				<div id="invoice">
					<h1>INVOICE #: '.$invoice_num.'</h1>
					<div class="date">Acc Number: '.$invoice_acc.'</div>
					<div class="date">Date of Invoice: '.$invoice_date.'</div>
					<div class="date">Payment Due Date: '.$billing_due.'</div>
					<div class="date">For Period: '.$invoice_period.'</div>
				</div>
			</div>
			<div id="details" class="clearfix">
				<div id="mail-address">
					'.$mailto.'
				</div>
				<div id="invoice">
					<h1></h1>
					<div class="date"></div>
					<div class="date"></div>
				</div>
			</div>
		</div>
		<div id="invoice-section" class="clearfix">
			<table border="0" cellspacing="0" cellpadding="0">
				<thead>
				<tr>
					<th class="no">#</th>
					<th class="desc">DESCRIPTION</th>
					<th class="unit">MONTHLY PRICE</th>
					<th class="qty">MONTHS</th>
					<th class="total">TOTAL</th>
				</tr>
				</thead>
				<tbody>
				<tr>
					<td class="no">1</td>
					<td class="desc"><h3>Central Station Monitoring Service</h3>Service Period ('.$invoice_period.')</td>
					<td class="unit"> $'.$invoice_amount.'</td>
					<td class="qty">'.$invoice_term.'</td>
					<td class="total">$'.$sub_total.'</td>
				</tr>
				</tbody>
				<tfoot>
				<tr>
					<td rowspan="2" colspan="2">
					</td>
					<td colspan="2">TAX '.$invoice_tax.'%</td>
					<td> $'.$tax_amount.'</td>
				</tr>
				<tr>
					<td colspan="2">GRAND TOTAL</td>
					<td>$'.$grand_total.'</td>
				</tr>
				</tfoot>
			</table>
			<div id="thanks">Thank you!</div>
			<div id="notices">
				<div>NOTICE:</div>
				<div class="notice">A finance charge of 1.5% will be made on unpaid balances after 30 days.<br>Invoice was created on a computer and is valid without the signature and seal.</div>
			</div>
		</div>
	</main>
';

$billing_footer = '
	<footer>
		Please cut this part and return it witg the check.
		<div id="return-section" class="clearfix">
			<div id="details" class="clearfix">
				<div id="client">
					<div class="to">PAYMENT FROM:</div>
					<h2 class="name">'.$account_name.'</h2>
					<div class="address">'.$meta["com_address"][0].' '.$address2.'</div>
					<div class="address">'.$meta["com_city"][0].', '.$meta["com_state"][0].' '.$meta["com_zip"][0].'</div>
				</div>
				<div id="invoice">
					<h1>INVOICE #: '.$invoice_num.'</h1>
					<div class="date">Acc Number: '.$invoice_acc.'</div>
					<div class="date">Date of Invoice: '.$invoice_date.'</div>
					<div class="date">Payment Due Date: '.$billing_due.'</div>
					<div class="date">For Period: '.$invoice_period.'</div>
				</div>
			</div>
			<div id="details" class="clearfix">
				<div id="client">
					<div class="to">Mail TO:</div>
					<h2 class="name">Sun World Security Inc.</h2>
					<div class="address">156-07 45th Ave</div>
					<div class="address">Flushing, NY 11355</div>
				</div>
				<div id="invoice">
					<h1>Amount: $'.$grand_total.'</h1>
					<div class="date">PAYABLE TO: <b>SUN WORLD SECURITY INC</b></div>
					<div class="date"></div>
					<div class="date"> NOTE: '.$invoice_note.'</div>
				</div>
			</div>
		</div>
	</footer>
	</body>
</html>';
$billing_content = $billing_header.$billing_body.$billing_footer;
	
//echo $billing_content;
// instantiate and use the dompdf class
$dompdf = new Dompdf();
$dompdf->loadHtml($billing_content);
 
// (Optional) Setup the paper size and orientation
$dompdf->set_paper( 'letter' , 'portrait' );
$dompdf->set_option('isRemoteEnabled', true);
//$dompdf->set_option('enable_css_float',true);
$dompdf->set_option('enable_html5_parser',true);
$dompdf->set_option('isHtml5ParserEnabled', true);
$dompdf->set_option('dpi','120');

// Render the HTML as PDF
$dompdf->render();
 
$doctitle = get_the_title($my_postid) . ' '.$invoice_num;
$dompdf->stream($doctitle);
 
exit();
}


if(isset($_GET['inv_id'])){
	$post_id = $_GET['inv_id'];

	$billing_table 	= $wpdb->prefix . 'gs_billing'; 
	$posts_table 	= $wpdb->prefix . 'posts'; 
	$billing_date 	= date("m/d/Y", strtotime($meta["billing_date"][0]));
	$billing_qry 	= '
		SELECT * 
		FROM '.$billing_table.' AS billing 
		INNER JOIN '.$posts_table.' AS company
		ON billing.post_id = company.ID 
		WHERE billing.post_id = "'.$post_id.'"';

	//echo $billing_qry;
	
	/*' 
    SELECT booking_calendars.cal_name
    FROM '.$wpdb->prefix.'booking_calendars AS booking_calendars
    INNER JOIN '. $wpdb->prefix.'booking_reservation AS booking_reservations
    ON booking_calendars.id =  booking_reservations.calendar_id
    WHERE status LIKE "pending"'
	*/
	$results = $wpdb->get_results($billing_qry);

	foreach($results as $row)
	{
		//print_r($row);
		$meta = get_post_meta($row->ID, '', true);
		$billing_due 	= date("m/d/Y", strtotime($meta["billing_date"][0]));
		$billing_address = "";
		if($meta["billing_diff"][0]==1){
			$billing_address = $meta["billing_address"][0].' '.$meta["billing_address2"][0].' '.$meta["billing_city"][0].', '.$meta["billing_state"][0].' '.$meta["billing_zip"][0];
		}else{
			$billing_address = $meta["com_address"][0].' '.$meta["com_address2"][0].' '.$meta["com_city"][0].', '.$meta["com_state"][0].' '.$meta["com_zip"][0];
		}
		$billing_status = $row->billing_status;
		switch ($i) {
			case 0:
				$b_status = "Unpaid";
			break;
			case 1:
				$b_status = "Paid Check";
			break;
			case 2:
				$b_status = "Paid Cash";
			break;
			case 3:
				$b_status = "Paid Card";
			break;
		}
		$company_edit = get_edit_post_link($row->ID);
		$company_view = the_permalink($row->ID);

$account_name = get_the_title($row->ID);
$account_address2 = isset($meta["com_address2"][0])?'<div class="address">'.$meta["com_address2"][0].'</div>':'';
$billing_address2 = isset($meta["billing_address2"][0])?'<div class="address">'.$meta["billing_address2"][0].'</div>':'';
$mailto = "";
if($meta["billing_diff"][0]==1){
	$mailto = '<h2 class="name">'.$account_name.'</h2>
			<div class="address">'.$meta["billing_address"][0].' '.$billing_address2.'</div>
			<div class="address">'.$meta["billing_city"][0].', '.$meta["billing_state"][0].' '.$meta["billing_zip"][0].'</div>';
}else{
	$mailto = '<h2 class="name">'.$account_name.'</h2>
			<div class="address">'.$meta["com_address"][0].' '.$account_address2.'</div>
			<div class="address">'.$meta["com_city"][0].', '.$meta["com_state"][0].' '.$meta["com_zip"][0].'</div>';
}

$tablename = $wpdb->prefix.'gs_billing';
$get_billing = $wpdb->get_results( $wpdb->prepare( 'SELECT * FROM ' .$tablename. ' WHERE `billing_account` = "'.$meta["signal_number"][0].'" ORDER BY id DESC LIMIT 1'));
$invoice_num 	= "";
$invoice_acc 	= "";
$invoice_date 	= "";
$invoice_method = "";
$invoice_term 	= "";
$invoice_amount = "";
$invoice_tax	= "";
$invoice_period = "";
foreach ( $get_billing as $billing_result )
{
	$invoice_num 	= $billing_result->billing_id;
	$invoice_acc 	= $billing_result->billing_account;
	$invoice_date 	= date("m/d/Y", strtotime($billing_result->billing_created));
	$invoice_method = $billing_result->billing_method;
	$invoice_note 	= $billing_result->billing_note;
	$invoice_term 	= $billing_result->billing_term;
	$invoice_amount = number_format($billing_result->billing_amount, 2,'.', ',');
	$invoice_tax	= $billing_result->billing_tax;
	$invoice_total	= $billing_result->billing_total;
	$invoice_period = $billing_result->billing_period;
}

//print_r($meta);
$billing_due 	= date("m/d/Y", strtotime($meta["billing_date"][0]));
//$billing_period = date("m/d/Y", strtotime($meta["billing_date"][0])).'~'.date("m/d/Y", strtotime($meta["billing_date"][0]. " + '.$invoice_term.' months"));
$sub_total 		= number_format($invoice_amount*$invoice_term, 2,'.', ',');
$tax_rate		= number_format(($invoice_tax/100), 5,'.', ',');
$tax_amount		= number_format(($invoice_amount*$invoice_term*$tax_rate), 2,'.', ',');
$grand_total 	= number_format($sub_total + $tax_amount, 2,'.', ',');;
		
	
	
	?>
<div class="wrap">
<main class="wp-block-group is-layout-flow">
<div class="wp-block-group is-layout-constrained">
	<form class="form-horizontal" id="" role="form" action="" method="post">
		<button type="submit" class="download-details">
			Download Invoice<i class="fa fa-download"></i>
		</button>
		<input type="hidden" name="action" value="generate-one-sheet" />
		<input type="hidden" name="postid" value="<?php echo $post_id; ?>" />
		<?php wp_nonce_field('verify_generate_one_sheet','nonce_generate_one_sheet'); ?>
	</form>
<hr class="wp-block-separator alignwide is-style-wide"/>
</div>
			<h1 style="margin-bottom:var(--wp--custom--spacing--medium, 6rem);" class="alignwide wp-block-post-title"><?php echo $title." - ".$meta_data['signal_number'][0];?></h1>
<?php
	}

	
	
}else{
		
}

?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div style="height:32px" aria-hidden="true" class="wp-block-spacer"></div>
<div class="entry-content wp-block-post-content is-layout-constrained">

<?php

?>
	<header class="clearfix">
		<div id="logo"><img src="<?php echo get_theme_file_uri("sunworld-favicon.png");?>"></div>
		<div id="company">
			<h2 class="name">Sun World Security Inc.</h2>
			<div>156-07 45th Ave, Flushing, NY 11355</div>
			<div>(347) 732 - 0101 / Fax (917) 563 - 1762</div>
			<div><a href="mailto:nysunworld@gmail.com">nysunworld@gmail.com</a></div>
		</div>
    </header>
	
	<main>
		<div id="mail-section" class="clearfix">
			<div id="details" class="clearfix">
				<div id="client">
					<div class="to">INVOICE TO:</div>
					<h2 class="name"><?php echo $account_name; ?></h2>
					<div class="address"><?php echo $meta["com_address"][0].' '.$address2; ?></div>
					<div class="address"><?php echo $meta["com_city"][0].', '.$meta["com_state"][0].' '.$meta["com_zip"][0]; ?></div>
				</div>
				<div id="invoice">
					<h1>INVOICE #: <?php echo $invoice_num; ?></h1>
					<div class="date">Acc Number: <?php echo $invoice_acc; ?></div>
					<div class="date">Date of Invoice: <?php echo $invoice_date; ?></div>
					<div class="date">Payment Due Date: <?php echo $billing_due; ?></div>
					<div class="date">For Period: <?php echo $invoice_period; ?></div>
				</div>
			</div>
			<div id="details" class="clearfix">
				<div id="mail-address">
					<?php echo $mailto; ?>
				</div>
				<div id="invoice">
					<h1></h1>
					<div class="date"></div>
					<div class="date"></div>
				</div>
			</div>
		</div>
		<div id="invoice-section" class="clearfix">
			<table border="0" cellspacing="0" cellpadding="0">
				<thead>
				<tr>
					<th class="no">#</th>
					<th class="desc">DESCRIPTION</th>
					<th class="unit">MONTHLY PRICE</th>
					<th class="qty">MONTHS</th>
					<th class="total">TOTAL</th>
				</tr>
				</thead>
				<tbody>
				<tr>
					<td class="no">1</td>
					<td class="desc"><h3>Central Station Monitoring Service</h3>Service Period (<?php echo $invoice_period; ?>)</td>
					<td class="unit"> $<?php echo $invoice_amount; ?></td>
					<td class="qty"><?php echo $invoice_term; ?></td>
					<td class="total">$<?php echo $sub_total; ?></td>
				</tr>
				</tbody>
				<tfoot>
				<tr>
					<td rowspan="2" colspan="2">
					</td>
					<td colspan="2">TAX <?php echo $invoice_tax; ?>%</td>
					<td> $<?php echo $tax_amount; ?></td>
				</tr>
				<tr>
					<td colspan="2">GRAND TOTAL</td>
					<td>$<?php echo $grand_total; ?></td>
				</tr>
				</tfoot>
			</table>
			<div id="thanks">Thank you!</div>
			<div id="notices">
				<div>NOTICE:</div>
				<div class="notice">A finance charge of 1.5% will be made on unpaid balances after 30 days.<br>Invoice was created on a computer and is valid without the signature and seal.</div>
			</div>
		</div>
		<pdf-footer>
			Please cut this part and return it witg the check.
			<div id="return-section" class="clearfix">
				<div id="details" class="clearfix">
					<div id="client">
						<div class="to">PAYMENT FROM:</div>
						<h2 class="name"><?php echo $account_name; ?></h2>
						<div class="address"><?php echo $meta["com_address"][0].' '.$address2; ?></div>
						<div class="address"><?php echo $meta["com_city"][0].', '.$meta["com_state"][0].' '.$meta["com_zip"][0]; ?></div>
					</div>
					<div id="invoice">
						<h1>INVOICE #: <?php echo $invoice_num; ?></h1>
						<div class="date">Acc Number: <?php echo $invoice_acc; ?></div>
						<div class="date">Date of Invoice: <?php echo $invoice_date; ?></div>
						<div class="date">Payment Due Date: <?php echo $billing_due; ?></div>
						<div class="date">For Period: <?php echo $invoice_period; ?></div>
					</div>
				</div>
				<div id="details" class="clearfix">
					<div id="client">
						<div class="to">Mail TO:</div>
						<h2 class="name">Sun World Security Inc.</h2>
						<div class="address">156-07 45th Ave</div>
						<div class="address">Flushing, NY 11355</div>
					</div>
					<div id="invoice">
						<h1>Amount: $<?php echo $grand_total; ?></h1>
						<div class="date">PAYABLE TO: <b>SUN WORLD SECURITY INC</b></div>
						<div class="date"></div>
						<div class="date"> NOTE: <?php echo $invoice_note; ?></div>
					</div>
				</div>
			</div>
		</pdf-footer>
	</main>


<div class="wp-block-group is-layout-constrained">
</div>
</main>
</div>