<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       gsoulinc.com
 * @since      1.0.0
 *
 * @package    GS_CRM
 * @subpackage GS_CRM/admin/partials
 */
?>
<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="wrap">
	<div id="icon-themes" class="icon32"></div>  
	<h2>Setting</h2>  
<?php
	if($_POST['create_billing']):
	global $wpdb; // this is how you get access to the database
	$args = array(
		'post_type' => 'company'
		// Several more arguments could go here. Last one without a comma.
	);

	// Query the posts:
	$company_qry = new WP_Query($args);

	while ($company_qry->have_posts() ) : $company_qry->the_post(); 
		$post_id 		= get_the_ID();
		$meta 			= get_post_meta( $post_id, '', true);
		$account_id 	= $meta["signal_number"][0];
		$bp_value 		= date("m/d/Y", strtotime($meta["billing_date"][0]))."~".date("m/d/Y", strtotime($meta["billing_date"][0]. " + ".$meta["billing_term"][0]." months"));

		//print_r($meta);
		echo "<br><br>";
		echo $account_id;
		echo "<br><br>";

		$tablename 		= $wpdb->prefix.'gs_billing';
		$query_select 	= 'SELECT id FROM ' .$tablename. ' WHERE billing_account = '.$account_id.' ORDER BY id DESC LIMIT 1';
		$last_id 		= $wpdb->get_var( 'SELECT id FROM ' .$tablename. ' ORDER BY id DESC LIMIT 1');
		$next_id 		= isset($last_id)?$last_id++:1;
		$prefix 		= "SW-";
		$pad_len 		= 7;
		$billing_number = $next_id+1000;
		$billing_id 	= sprintf("%s%s", $prefix, str_pad($billing_number, $pad_len, "0", STR_PAD_LEFT));
	
		$check_pre_billing = $wpdb->get_results( $wpdb->prepare( 'SELECT id, billing_id, billing_status FROM ' .$tablename. ' WHERE `billing_account` = "'.$account_id.'" ORDER BY id DESC LIMIT 1'));
		//print_r($meta);

		//echo $check_pre_billing->'billing_status';
		$unpaid_invoice  = "";
		$last_billing_id = "";
		foreach ( $check_pre_billing as $pre_billing_result )
		{
			$unpaid_invoice  = $pre_billing_result->billing_status;
			$last_billing_id = $pre_billing_result->id;
		}

		if($unpaid_invoice!=0){

			$bt_value 	= get_post_meta( $post_id, 'billing_term', true );
			$ba_value 	= get_post_meta( $post_id, 'billing_amount', true );
			$bx_value 	= get_post_meta( $post_id, 'billing_tax', true );
			$bm_value 	= get_post_meta( $post_id, 'billing_method', true );
			$bd_value 	= get_post_meta( $post_id, 'billing_date', true );
			$bt_value 	= get_post_meta( $post_id, 'billing_term', true );
			$bx_rate	= number_format(($bx_value/100), 5,'.', ',');
			$btl_value 	= number_format($ba_value*$bt_value+($ba_value*$bt_value*$bx_rate), 2,'.', ',');
			$bn_value 	= get_post_meta( $post_id, 'billing_note', true );
			$b_time 	= current_datetime()->format('Y-m-d H:i:s');
			$wpdb->insert( $tablename, array(
				'post_id' => $post_id, 
				'billing_id' => $billing_id, 
				'billing_created' => $b_time,
				'billing_status' => '0', 
				'billing_completed' => "",
				'billing_account' => $account_id, 
				'billing_method' => $bm_value, 
				'billing_term' => $bt_value,
				'billing_amount' => $ba_value, 
				'billing_tax' => $bx_value, 
				'billing_period' => $bp_value, 
				'billing_total' => $btl_value, 
				'billing_note' => $bn_value,
				'billing_updated' => $b_time),
					  array( '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s' ) 
			);
			echo "Invoice generated successfully!";
		}else{
			$bt_value 	= get_post_meta( $post_id, 'billing_term', true );
			$ba_value 	= get_post_meta( $post_id, 'billing_amount', true );
			$bx_value 	= get_post_meta( $post_id, 'billing_tax', true );
			$bm_value 	= get_post_meta( $post_id, 'billing_method', true );
			$bd_value 	= get_post_meta( $post_id, 'billing_date', true );
			$bt_value 	= get_post_meta( $post_id, 'billing_term', true );
			$bx_rate	= number_format(($bx_value/100), 5,'.', ',');
			$btl_value 	= number_format($ba_value*$bt_value+($ba_value*$bt_value*$bx_rate), 2,'.', ',');
			$bn_value 	= get_post_meta( $post_id, 'billing_note', true );
			$b_time 	= current_datetime()->format('Y-m-d H:i:s');


			$wpdb->update( $tablename, array(
				'billing_id' 		=> $billing_id, 
				'billing_created' 	=> $b_time,
				'billing_status' 	=> '0', 
				'billing_completed' => "",
				'billing_account' 	=> $account_id, 
				'billing_method' 	=> $bm_value, 
				'billing_term' 		=> $bt_value,
				'billing_amount' 	=> $ba_value, 
				'billing_tax' 		=> $bx_value, 
				'billing_period' 	=> $bp_value, 
				'billing_total' 	=> $btl_value,
				'billing_note' 		=> $bn_value,
				'billing_updated' 	=> $b_time),
				array('ID' => $last_billing_id )

			);
			echo "Last ID ". $last_billing_id ." Updated Account ". $account_id ."<br>";
			echo "Unpaid previous invoice already exist. Invoice data has been updated.";		
		}
		
	endwhile;	
	endif;
?>
	<form method="POST" action="">  
		<input type="submit" name="create_billing" value="Create Billing Invoice" />
	</form> 
</div>