<?php

if ( ! function_exists( 'cevian_select_map_general_meta' ) ) {
	function cevian_select_map_general_meta() {
		
		$general_meta_box = cevian_select_create_meta_box(
			array(
				'scope' => apply_filters( 'cevian_select_filter_set_scope_for_meta_boxes', array( 'page', 'post' ), 'general_meta' ),
				'title' => esc_html__( 'General', 'cevian' ),
				'name'  => 'general_meta'
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_slider_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Slider Shortcode', 'cevian' ),
				'description' => esc_html__( 'Paste your slider shortcode here', 'cevian' ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Slider Layout - begin **********************/
		
		/***************** Content Layout - begin **********************/
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_page_content_behind_header_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Always put content behind header', 'cevian' ),
				'description'   => esc_html__( 'Enabling this option will put page content behind page header', 'cevian' ),
				'parent'        => $general_meta_box
			)
		);
		
		$qodef_content_padding_group = cevian_select_add_admin_group(
			array(
				'name'        => 'content_padding_group',
				'title'       => esc_html__( 'Content Styles', 'cevian' ),
				'description' => esc_html__( 'Define styles for Content area', 'cevian' ),
				'parent'      => $general_meta_box
			)
		);
		
			$qodef_content_padding_row = cevian_select_add_admin_row(
				array(
					'name'   => 'qodef_content_padding_row',
					'parent' => $qodef_content_padding_group
				)
			);
			
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_background_color_meta',
						'type'        => 'colorsimple',
						'label'       => esc_html__( 'Page Background Color', 'cevian' ),
						'parent'      => $qodef_content_padding_row
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_page_background_image_meta',
						'type'          => 'imagesimple',
						'label'         => esc_html__( 'Page Background Image', 'cevian' ),
						'parent'        => $qodef_content_padding_row
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_page_background_repeat_meta',
						'type'          => 'selectsimple',
						'default_value' => '',
						'label'         => esc_html__( 'Page Background Image Repeat', 'cevian' ),
						'options'       => cevian_select_get_yes_no_select_array(),
						'parent'        => $qodef_content_padding_row
					)
				);
		
			$qodef_content_padding_row_1 = cevian_select_add_admin_row(
				array(
					'name'   => 'qodef_content_padding_row_1',
					'next'   => true,
					'parent' => $qodef_content_padding_group
				)
			);
		
				cevian_select_create_meta_box_field(
					array(
						'name'   => 'qodef_page_content_padding',
						'type'   => 'textsimple',
						'label'  => esc_html__( 'Content Padding (eg. 10px 5px 10px 5px)', 'cevian' ),
						'parent' => $qodef_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'    => 'qodef_page_content_padding_mobile',
						'type'    => 'textsimple',
						'label'   => esc_html__( 'Content Padding for mobile (eg. 10px 5px 10px 5px)', 'cevian' ),
						'parent'  => $qodef_content_padding_row_1,
						'args'        => array(
							'col_width' => 4
						)
					)
				);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_initial_content_width_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Initial Width of Content', 'cevian' ),
				'description'   => esc_html__( 'Choose the initial width of content which is in grid (Applies to pages set to "Default Template" and rows set to "In Grid")', 'cevian' ),
				'parent'        => $general_meta_box,
				'options'       => array(
					''                => esc_html__( 'Default', 'cevian' ),
					'qodef-grid-1300' => esc_html__( '1300px', 'cevian' ),
					'qodef-grid-1200' => esc_html__( '1200px', 'cevian' ),
					'qodef-grid-1100' => esc_html__( '1100px', 'cevian' ),
					'qodef-grid-1000' => esc_html__( '1000px', 'cevian' ),
					'qodef-grid-800'  => esc_html__( '800px', 'cevian' )
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_grid_space_meta',
				'type'        => 'select',
				'default_value' => '',
				'label'       => esc_html__( 'Grid Layout Space', 'cevian' ),
				'description' => esc_html__( 'Choose a space between content layout and sidebar layout for your page', 'cevian' ),
				'options'     => cevian_select_get_space_between_items_array( true ),
				'parent'      => $general_meta_box
			)
		);
		
		/***************** Content Layout - end **********************/
		
		/***************** Boxed Layout - begin **********************/
		
		cevian_select_create_meta_box_field(
			array(
				'name'    => 'qodef_boxed_meta',
				'type'    => 'select',
				'label'   => esc_html__( 'Boxed Layout', 'cevian' ),
				'parent'  => $general_meta_box,
				'options' => cevian_select_get_yes_no_select_array()
			)
		);
		
			$boxed_container_meta = cevian_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'boxed_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_boxed_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_background_color_in_box_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Page Background Color', 'cevian' ),
						'description' => esc_html__( 'Choose the page background color outside box', 'cevian' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_boxed_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Image', 'cevian' ),
						'description' => esc_html__( 'Choose an image to be displayed in background', 'cevian' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_boxed_pattern_background_image_meta',
						'type'        => 'image',
						'label'       => esc_html__( 'Background Pattern', 'cevian' ),
						'description' => esc_html__( 'Choose an image to be used as background pattern', 'cevian' ),
						'parent'      => $boxed_container_meta
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'          => 'qodef_boxed_background_image_attachment_meta',
						'type'          => 'select',
						'default_value' => '',
						'label'         => esc_html__( 'Background Image Attachment', 'cevian' ),
						'description'   => esc_html__( 'Choose background image attachment', 'cevian' ),
						'parent'        => $boxed_container_meta,
						'options'       => array(
							''       => esc_html__( 'Default', 'cevian' ),
							'fixed'  => esc_html__( 'Fixed', 'cevian' ),
							'scroll' => esc_html__( 'Scroll', 'cevian' )
						)
					)
				);
		
		/***************** Boxed Layout - end **********************/
		
		/***************** Passepartout Layout - begin **********************/
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_paspartu_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Passepartout', 'cevian' ),
				'description'   => esc_html__( 'Enabling this option will display passepartout around site content', 'cevian' ),
				'parent'        => $general_meta_box,
				'options'       => cevian_select_get_yes_no_select_array(),
			)
		);
		
			$paspartu_container_meta = cevian_select_add_admin_container(
				array(
					'parent'          => $general_meta_box,
					'name'            => 'qodef_paspartu_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_paspartu_meta'  => array('','no')
						)
					)
				)
			);
		
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_color_meta',
						'type'        => 'color',
						'label'       => esc_html__( 'Passepartout Color', 'cevian' ),
						'description' => esc_html__( 'Choose passepartout color, default value is #ffffff', 'cevian' ),
						'parent'      => $paspartu_container_meta
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Passepartout Size', 'cevian' ),
						'description' => esc_html__( 'Enter size amount for passepartout', 'cevian' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_paspartu_responsive_width_meta',
						'type'        => 'text',
						'label'       => esc_html__( 'Responsive Passepartout Size', 'cevian' ),
						'description' => esc_html__( 'Enter size amount for passepartout for smaller screens (tablets and mobiles view)', 'cevian' ),
						'parent'      => $paspartu_container_meta,
						'args'        => array(
							'col_width' => 2,
							'suffix'    => 'px or %'
						)
					)
				);
				
				cevian_select_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'qodef_disable_top_paspartu_meta',
						'label'         => esc_html__( 'Disable Top Passepartout', 'cevian' ),
						'options'       => cevian_select_get_yes_no_select_array(),
					)
				);
		
				cevian_select_create_meta_box_field(
					array(
						'parent'        => $paspartu_container_meta,
						'type'          => 'select',
						'default_value' => '',
						'name'          => 'qodef_enable_fixed_paspartu_meta',
						'label'         => esc_html__( 'Enable Fixed Passepartout', 'cevian' ),
						'description'   => esc_html__( 'Enabling this option will set fixed passepartout for your screens', 'cevian' ),
						'options'       => cevian_select_get_yes_no_select_array(),
					)
				);
		
		/***************** Passepartout Layout - end **********************/
		
		/***************** Smooth Page Transitions Layout - begin **********************/
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_smooth_page_transitions_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Smooth Page Transitions', 'cevian' ),
				'description'   => esc_html__( 'Enabling this option will perform a smooth transition between pages when clicking on links', 'cevian' ),
				'parent'        => $general_meta_box,
				'options'       => cevian_select_get_yes_no_select_array()
			)
		);
		
			$page_transitions_container_meta = cevian_select_add_admin_container(
				array(
					'parent'     => $general_meta_box,
					'name'       => 'page_transitions_container_meta',
					'dependency' => array(
						'hide' => array(
							'qodef_smooth_page_transitions_meta' => array( '', 'no' )
						)
					)
				)
			);
		
				cevian_select_create_meta_box_field(
					array(
						'name'        => 'qodef_page_transition_preloader_meta',
						'type'        => 'select',
						'label'       => esc_html__( 'Enable Preloading Animation', 'cevian' ),
						'description' => esc_html__( 'Enabling this option will display an animated preloader while the page content is loading', 'cevian' ),
						'parent'      => $page_transitions_container_meta,
						'options'     => cevian_select_get_yes_no_select_array()
					)
				);
		
				$page_transition_preloader_container_meta = cevian_select_add_admin_container(
					array(
						'parent'     => $page_transitions_container_meta,
						'name'       => 'page_transition_preloader_container_meta',
						'dependency' => array(
							'hide' => array(
								'qodef_page_transition_preloader_meta' => array( '', 'no' )
							)
						)
					)
				);
				
					cevian_select_create_meta_box_field(
						array(
							'name'   => 'qodef_smooth_pt_bgnd_color_meta',
							'type'   => 'color',
							'label'  => esc_html__( 'Page Loader Background Color', 'cevian' ),
							'parent' => $page_transition_preloader_container_meta
						)
					);
					
					$group_pt_spinner_animation_meta = cevian_select_add_admin_group(
						array(
							'name'        => 'group_pt_spinner_animation_meta',
							'title'       => esc_html__( 'Loader Style', 'cevian' ),
							'description' => esc_html__( 'Define styles for loader spinner animation', 'cevian' ),
							'parent'      => $page_transition_preloader_container_meta
						)
					);
					
					$row_pt_spinner_animation_meta = cevian_select_add_admin_row(
						array(
							'name'   => 'row_pt_spinner_animation_meta',
							'parent' => $group_pt_spinner_animation_meta
						)
					);
					
					cevian_select_create_meta_box_field(
						array(
							'type'    => 'selectsimple',
							'name'    => 'qodef_smooth_pt_spinner_type_meta',
							'label'   => esc_html__( 'Spinner Type', 'cevian' ),
							'parent'  => $row_pt_spinner_animation_meta,
							'options' => array(
								''                      => esc_html__( 'Default', 'cevian' ),
								'cevian_spinner'        => esc_html__( 'Cevian Spinner', 'cevian' ),
								'rotate_circles'        => esc_html__( 'Rotate Circles', 'cevian' ),
								'pulse'                 => esc_html__( 'Pulse', 'cevian' ),
								'double_pulse'          => esc_html__( 'Double Pulse', 'cevian' ),
								'cube'                  => esc_html__( 'Cube', 'cevian' ),
								'rotating_cubes'        => esc_html__( 'Rotating Cubes', 'cevian' ),
								'stripes'               => esc_html__( 'Stripes', 'cevian' ),
								'wave'                  => esc_html__( 'Wave', 'cevian' ),
								'two_rotating_circles'  => esc_html__( '2 Rotating Circles', 'cevian' ),
								'five_rotating_circles' => esc_html__( '5 Rotating Circles', 'cevian' ),
								'atom'                  => esc_html__( 'Atom', 'cevian' ),
								'clock'                 => esc_html__( 'Clock', 'cevian' ),
								'mitosis'               => esc_html__( 'Mitosis', 'cevian' ),
								'lines'                 => esc_html__( 'Lines', 'cevian' ),
								'fussion'               => esc_html__( 'Fussion', 'cevian' ),
								'wave_circles'          => esc_html__( 'Wave Circles', 'cevian' ),
								'pulse_circles'         => esc_html__( 'Pulse Circles', 'cevian' )
							)
						)
					);
					
					cevian_select_create_meta_box_field(
						array(
							'type'   => 'colorsimple',
							'name'   => 'qodef_smooth_pt_spinner_color_meta',
							'label'  => esc_html__( 'Spinner Color', 'cevian' ),
							'parent' => $row_pt_spinner_animation_meta
						)
					);
					
					cevian_select_create_meta_box_field(
						array(
							'name'        => 'qodef_page_transition_fadeout_meta',
							'type'        => 'select',
							'label'       => esc_html__( 'Enable Fade Out Animation', 'cevian' ),
							'description' => esc_html__( 'Enabling this option will turn on fade out animation when leaving page', 'cevian' ),
							'options'     => cevian_select_get_yes_no_select_array(),
							'parent'      => $page_transitions_container_meta
						
						)
					);
		
		/***************** Smooth Page Transitions Layout - end **********************/
		
		/***************** Comments Layout - begin **********************/
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_page_comments_meta',
				'type'        => 'select',
				'label'       => esc_html__( 'Show Comments', 'cevian' ),
				'description' => esc_html__( 'Enabling this option will show comments on your page', 'cevian' ),
				'parent'      => $general_meta_box,
				'options'     => cevian_select_get_yes_no_select_array()
			)
		);
		
		/***************** Comments Layout - end **********************/


        /***************** main color - begin **********************/

        cevian_select_create_meta_box_field(
            array(
                'name'        => 'qodef_first_color_meta',
                'type'        => 'color',
                'label'       => esc_html__( 'Page Main Color', 'cevian' ),
                'description' => esc_html__( 'Choose main color on this page for most elements', 'cevian' ),
                'parent'      => $general_meta_box,
            )
        );

        cevian_select_create_meta_box_field(
            array(
                'name'        => 'qodef_back_to_top_skin_meta',
                'type'        => 'select',
                'default'     => '',
                'label'       => esc_html__( 'Back To Top Skin', 'cevian' ),
                'description' => esc_html__( 'Choose skin for "Back to top" button', 'cevian' ),
                'parent'      => $general_meta_box,
                'options'     => array(
                    ''  => esc_html__('Default', 'cevian'),
                    'light'  => esc_html__('Light', 'cevian')
                )
            )
        );

        /***************** main color - end **********************/
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_select_map_general_meta', 10 );
}

if ( ! function_exists( 'cevian_select_container_background_style' ) ) {
	/**
	 * Function that return container style
	 */
	function cevian_select_container_background_style( $style ) {
		$page_id      = cevian_select_get_page_id();
		$class_prefix = cevian_select_get_unique_page_class( $page_id, true );
		
		$container_selector = array(
			$class_prefix . ' .qodef-content'
		);
		
		$container_class        = array();
		$page_background_color  = get_post_meta( $page_id, 'qodef_page_background_color_meta', true );
		$page_background_image  = get_post_meta( $page_id, 'qodef_page_background_image_meta', true );
		$page_background_repeat = get_post_meta( $page_id, 'qodef_page_background_repeat_meta', true );
		
		if ( ! empty( $page_background_color ) ) {
			$container_class['background-color'] = $page_background_color;
		}
		
		if ( ! empty( $page_background_image ) ) {
			$container_class['background-image'] = 'url(' . esc_url( $page_background_image ) . ')';
			
			if ( $page_background_repeat === 'yes' ) {
				$container_class['background-repeat']   = 'repeat';
				$container_class['background-position'] = '0 0';
			} else {
				$container_class['background-repeat']   = 'no-repeat';
				$container_class['background-position'] = 'center 0';
				$container_class['background-size']     = 'cover';
			}
		}
		
		$current_style = cevian_select_dynamic_css( $container_selector, $container_class );
		$current_style = $current_style . $style;
		
		return $current_style;
	}
	
	add_filter( 'cevian_select_filter_add_page_custom_style', 'cevian_select_container_background_style' );
}

if ( ! function_exists( 'cevian_select_main_color' ) ) {

    function cevian_select_main_color( $style ) {
        $page_id            = cevian_select_get_page_id();
        $class_prefix       = cevian_select_get_unique_page_class( $page_id, true );
        $first_main_color   = get_post_meta( $page_id, 'qodef_first_color_meta', true );
        $temp_style = '';

        if ( ! empty( $first_main_color ) ) {
            $color_selector = $color_important_selector = $background_color_selector = $background_color_important_selector = $border_color_selector = $border_color_important_selector = $fill_color_selector = $fill_color_important_selector = $stroke_color_selector = $stroke_color_important_selector = array();

            // Include first main color selectors
            include_once SELECT_ASSETS_ROOT_DIR . '/custom-styles/parts/first-main-color.php';

            if ( cevian_select_is_plugin_installed( 'woocommerce' ) ) {
                $woo_color_selector = $woo_color_important_selector = $woo_background_color_selector = $woo_background_color_important_selector = $woo_border_color_selector = $woo_border_color_important_selector = $woo_fill_color_selector = $woo_fill_color_important_selector = $woo_stroke_color_selector = $woo_stroke_color_important_selector = array();

                // Include first main color WooCommerce selectors
                include_once SELECT_ASSETS_ROOT_DIR . '/custom-styles/parts/woocommerce-first-main-color.php';

                if ( isset( $woo_color_selector ) && ! empty( $woo_color_selector ) ) {
                    $color_selector = array_merge( $color_selector, $woo_color_selector );
                }

                if ( isset( $woo_color_important_selector ) && ! empty( $woo_color_important_selector ) ) {
                    $color_important_selector = array_merge( $color_important_selector, $woo_color_important_selector );
                }

                if ( isset( $woo_background_color_selector ) && ! empty( $woo_background_color_selector ) ) {
                    $background_color_selector = array_merge( $background_color_selector, $woo_background_color_selector );
                }

                if ( isset( $woo_background_color_important_selector ) && ! empty( $woo_background_color_important_selector ) ) {
                    $background_color_important_selector = array_merge( $background_color_important_selector, $woo_background_color_important_selector );
                }

                if ( isset( $woo_border_color_selector ) && ! empty( $woo_border_color_selector ) ) {
                    $border_color_selector = array_merge( $border_color_selector, $woo_border_color_selector );
                }

                if ( isset( $woo_border_color_important_selector ) && ! empty( $woo_border_color_important_selector ) ) {
                    $border_color_important_selector = array_merge( $border_color_important_selector, $woo_border_color_important_selector );
                }

                if ( isset( $woo_fill_color_selector ) && ! empty( $woo_fill_color_selector ) ) {
                    $fill_color_selector = array_merge( $fill_color_selector, $woo_fill_color_selector );
                }

                if ( isset( $woo_fill_color_important_selector ) && ! empty( $woo_fill_color_important_selector ) ) {
                    $fill_color_important_selector = array_merge( $fill_color_important_selector, $woo_fill_color_important_selector );
                }

                if ( isset( $woo_stroke_color_selector ) && ! empty( $woo_stroke_color_selector ) ) {
                    $stroke_color_selector = array_merge( $stroke_color_selector, $woo_stroke_color_selector );
                }

                if ( isset( $woo_stroke_color_important_selector ) && ! empty( $woo_stroke_color_important_selector ) ) {
                    $stroke_color_important_selector = array_merge( $stroke_color_important_selector, $woo_stroke_color_important_selector );
                }
            }

            if ( isset( $color_selector )  ) {
                $color_selector[] = '.qodef-main-menu>ul>li>a';
                $color_selector[] = '.qodef-main-menu>ul>li.qodef-active-item>a, .qodef-main-menu>ul>li>a:hover';
                $color_selector[] = '.qodef-footer-bottom-holder .qodef-icon-widget-holder .qodef-icon-element, .qodef-footer-bottom-holder .qodef-icon-widget-holder .qodef-icon-text';
                $color_selector[] = '.qodef-page-footer .qodef-footer-bottom-holder .qodef-grid-col-6 .qodef-social-icons-group-widget a.qodef-social-icon-widget-holder';
                $color_selector[] = '.qodef-page-footer .qodef-footer-bottom-holder .qodef-grid-col-4 .qodef-social-icons-group-widget a.qodef-social-icon-widget-holder';
                $color_selector[] = '.qodef-page-footer .qodef-footer-bottom-holder .qodef-grid-col-12 .qodef-social-icons-group-widget a.qodef-social-icon-widget-holder';
                $color_selector[] = '.qodef-top-bar .qodef-icon-widget-holder .qodef-icon-element, .qodef-top-bar .qodef-icon-widget-holder .qodef-icon-text';
                $color_selector[] = '.qodef-top-bar .widget a.qodef-social-icon-widget-holder';
                $color_selector[] = '.qodef-blog-list-holder.qodef-bl-minimal .qodef-post-title';
                $color_selector[] = '.qodef-blog-list-holder.qodef-bl-minimal .qodef-post-info-date a';
                $color_selector[] = '.qodef-iwt .qodef-post-read-more-button .qodef-btn.qodef-btn-minimal';
                $color_selector[] = '.qodef-iwt .qodef-post-read-more-button .qodef-btn.qodef-btn-minimal .icon_plus:before';
                $color_selector[] = 'div.wpcf7 .qodef-contact-form .wpcf7-form-control.wpcf7-text';
                $color_selector[] = 'div.wpcf7 .qodef-contact-form .wpcf7-form-control.wpcf7-submit.qodef-btn';
                $color_selector[] = '#qodef-back-to-top>span i';
                $color_selector[] = '#qodef-back-to-top>span .qodef-back-to-top-text';
                $color_selector[] = '.qodef-blog-list-holder.qodef-bl-minimal .qodef-post-info-date a:hover';
                $color_selector[] = '.qodef-blog-list-holder.qodef-bl-minimal .qodef-post-info-category a:hover';


                //remove color selectors for fullscreen menu since we dont want them to fallow page main color logic
                if (($key = array_search('nav.qodef-fullscreen-menu ul li a', $color_selector)) !== false) {
                    unset($color_selector[$key]);
                }

                if (($key = array_search('nav.qodef-fullscreen-menu>ul>li>a', $color_selector)) !== false) {
                    unset($color_selector[$key]);
                }

                if (($key = array_search('nav.qodef-fullscreen-menu ul li ul li.current-menu-item>a', $color_selector)) !== false) {
                    unset($color_selector[$key]);
                }

                $color_selector_alpha[] = '.qodef-price-table .qodef-pt-inner ul li.qodef-pt-content ul li';
                $color_selector_alpha[] = '.qodef-price-table .qodef-pt-inner ul li.qodef-pt-subtitle-holder .qodef-pt-subtitle';
                $color_selector_alpha[] = '.qodef-price-table .qodef-pt-inner ul li.qodef-pt-prices .qodef-pt-mark';

                $color_selector_alpha_aux[] = '.qodef-top-bar .qodef-icon-widget-holder:hover .qodef-icon-text';
                $color_selector_alpha_aux[] = '.qodef-top-bar .qodef-icon-widget-holder:hover .qodef-icon-element';

                $temp_style .= cevian_select_dynamic_css( $color_selector, array( 'color' => $first_main_color ) );

                $temp_style .= cevian_select_dynamic_css( $color_selector_alpha, array( 'color' => 'rgba('.implode(',',cevian_select_hex2rgb($first_main_color)).',.65)' ) );

                $temp_style .= cevian_select_dynamic_css( $color_selector_alpha_aux, array( 'color' => 'rgba('.implode(',',cevian_select_hex2rgb($first_main_color)).',.8)' ) );
            }

            if ( isset( $color_important_selector ) ) {
                $temp_style .= cevian_select_dynamic_css( $color_important_selector, array( 'color' => $first_main_color . '!important' ) );
            }

            if ( isset( $background_color_selector )  ) {

                $background_color_selector[] = '.qodef-frame-slider-holder .qodef-owl-slider .owl-dots .owl-dot.active span';

                $background_aux_color_selector[] = '.qodef-price-table.qodef-pt-active-item .qodef-pt-inner';
                $background_button_aux_color_selector[] = '.qodef-price-table.qodef-pt-active-item .qodef-pt-inner ul li.qodef-pt-button .qodef-btn';

                $temp_style .= cevian_select_dynamic_css( $background_color_selector, array( 'background-color' => $first_main_color ) );
                $temp_style .= cevian_select_dynamic_css( $background_aux_color_selector, array( 'background-color' => 'transparent' ) );
                $temp_style .= cevian_select_dynamic_css( $background_aux_color_selector, array( 'box-shadow' => 'none' ) );
                $temp_style .= cevian_select_dynamic_css( $background_button_aux_color_selector, array( 'background-color' => '#fff' ) );
                $temp_style .= cevian_select_dynamic_css( $background_button_aux_color_selector, array( 'border-color' => '#fff' ) );
            }

            /* Background with transparency */

                // $background_color_selector_alpha[] = '.qodef-top-bar .qodef-social-icons-group-widget .qodef-social-icon-widget-holder:hover, .qodef-top-bar .qodef-social-icons-group-widget .qodef-social-icon-widget-holder:hover';
                // $background_color_selector_alpha[] = '.qodef-iwt.qodef-iwt-icon-left.qodef-iwt-dark-hover:hover';
                // $background_color_selector_alpha[] = '.qodef-social-icons-group-widget .qodef-social-icon-widget-holder:hover';
                $background_color_selector_alpha[] = 'div.wpcf7 .qodef-contact-form .wpcf7-form-control.wpcf7-submit.qodef-btn';
                $background_color_selector_alpha[] = '.qodef-frame-slider-holder .qodef-owl-slider .owl-dots .owl-dot span';

                $temp_style .= cevian_select_dynamic_css( $background_color_selector_alpha, array( 'background-color' => 'rgba('.implode(',',cevian_select_hex2rgb($first_main_color)).',.55)' ) );

//            $background_color_selector_aux[] = 'footer .qodef-social-icons-group-widget .qodef-social-icon-widget-holder:hover';
//
//            $temp_style .= cevian_select_dynamic_css( $background_color_selector_aux, array( 'background-color' => 'rgba('.implode(',',cevian_select_hex2rgb($first_main_color)).',.15)' ) );


            if ( isset( $background_color_important_selector )  ) {
                $temp_style .= cevian_select_dynamic_css( $background_color_important_selector, array( 'background-color' => $first_main_color . '!important' ) );
            }

            if ( isset( $border_color_selector )  ) {
                $border_color_selector[] = '.qodef-main-menu .qodef-main-menu-line';
                $border_color_selector[] = '#qodef-back-to-top>span';
                $border_color_selector[] = '#qodef-back-to-top>span:hover';
                $border_color_selector[] = '.qodef-iwt .qodef-iwt-readmore .qodef-btn';

                $temp_style .= cevian_select_dynamic_css( $border_color_selector, array( 'border-color' => $first_main_color ) );

                $border_color_selector_alpha[] = '.qodef-iwt .qodef-post-read-more-button .qodef-btn.qodef-btn-minimal';
                $temp_style .= cevian_select_dynamic_css( $border_color_selector_alpha, array( 'border-color' => 'rgba('.implode(',',cevian_select_hex2rgb($first_main_color)).',.25)' ) );
            }

            if ( isset( $border_color_important_selector )  ) {
                $temp_style .= cevian_select_dynamic_css( $border_color_important_selector, array( 'border-color' => $first_main_color . '!important' ) );
            }

            if ( isset( $fill_color_selector ) ) {
                $fill_color_selector[] = '.qodef-footer-bottom-holder svg path';
                $fill_color_selector[] = '.qodef-side-menu-button-opener svg circle';
                $fill_color_selector[] = '.qodef-fullscreen-menu-opener svg circle';
                $fill_color_selector[] = '.qodef-mobile-menu-opener svg circle';

                $temp_style .= cevian_select_dynamic_css( $fill_color_selector, array( 'fill' => $first_main_color ) );
            }

            if ( isset( $fill_color_important_selector )  ) {
                $temp_style .= cevian_select_dynamic_css( $fill_color_important_selector, array( 'fill' => $first_main_color . '!important' ) );
            }

            if ( isset( $stroke_color_selector )  ) {
                $temp_style .= cevian_select_dynamic_css( $stroke_color_selector, array( 'stroke' => $first_main_color ) );
            }

            if ( isset( $stroke_color_important_selector ) ) {
                $temp_style .= cevian_select_dynamic_css( $stroke_color_important_selector, array( 'stroke' => $first_main_color . '!important' ) );
            }
        }

        $current_style = $temp_style . $style;

        return $current_style;
    }

    add_filter( 'cevian_select_filter_add_page_custom_style', 'cevian_select_main_color' );
}