<?php

if ( ! function_exists( 'cevian_select_map_post_audio_meta' ) ) {
	function cevian_select_map_post_audio_meta() {
		$audio_post_format_meta_box = cevian_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Audio Post Format', 'cevian' ),
				'name'  => 'post_format_audio_meta'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_audio_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Audio Type', 'cevian' ),
				'description'   => esc_html__( 'Choose audio type', 'cevian' ),
				'parent'        => $audio_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Audio Service', 'cevian' ),
					'self'            => esc_html__( 'Self Hosted', 'cevian' )
				)
			)
		);
		
		$qodef_audio_embedded_container = cevian_select_add_admin_container(
			array(
				'parent' => $audio_post_format_meta_box,
				'name'   => 'qodef_audio_embedded_container'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio URL', 'cevian' ),
				'description' => esc_html__( 'Enter audio URL', 'cevian' ),
				'parent'      => $qodef_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_audio_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_audio_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Audio Link', 'cevian' ),
				'description' => esc_html__( 'Enter audio link', 'cevian' ),
				'parent'      => $qodef_audio_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_audio_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_select_map_post_audio_meta', 23 );
}