<?php

if ( ! function_exists( 'cevian_select_map_post_video_meta' ) ) {
	function cevian_select_map_post_video_meta() {
		$video_post_format_meta_box = cevian_select_create_meta_box(
			array(
				'scope' => array( 'post' ),
				'title' => esc_html__( 'Video Post Format', 'cevian' ),
				'name'  => 'post_format_video_meta'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_video_type_meta',
				'type'          => 'select',
				'label'         => esc_html__( 'Video Type', 'cevian' ),
				'description'   => esc_html__( 'Choose video type', 'cevian' ),
				'parent'        => $video_post_format_meta_box,
				'default_value' => 'social_networks',
				'options'       => array(
					'social_networks' => esc_html__( 'Video Service', 'cevian' ),
					'self'            => esc_html__( 'Self Hosted', 'cevian' )
				)
			)
		);
		
		$qodef_video_embedded_container = cevian_select_add_admin_container(
			array(
				'parent' => $video_post_format_meta_box,
				'name'   => 'qodef_video_embedded_container'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_link_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video URL', 'cevian' ),
				'description' => esc_html__( 'Enter Video URL', 'cevian' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'social_networks'
					)
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_custom_meta',
				'type'        => 'text',
				'label'       => esc_html__( 'Video MP4', 'cevian' ),
				'description' => esc_html__( 'Enter video URL for MP4 format', 'cevian' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'self'
					)
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_post_video_image_meta',
				'type'        => 'image',
				'label'       => esc_html__( 'Video Image', 'cevian' ),
				'description' => esc_html__( 'Enter video image', 'cevian' ),
				'parent'      => $qodef_video_embedded_container,
				'dependency' => array(
					'show' => array(
						'qodef_video_type_meta' => 'self'
					)
				)
			)
		);
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_select_map_post_video_meta', 22 );
}