<?php

if ( ! function_exists( 'cevian_select_footer_options_map' ) ) {
	function cevian_select_footer_options_map() {

		cevian_select_add_admin_page(
			array(
				'slug'  => '_footer_page',
				'title' => esc_html__( 'Footer', 'cevian' ),
				'icon'  => 'fa fa-sort-amount-asc'
			)
		);

		$footer_panel = cevian_select_add_admin_panel(
			array(
				'title' => esc_html__( 'Footer', 'cevian' ),
				'name'  => 'footer',
				'page'  => '_footer_page'
			)
		);

		cevian_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'footer_in_grid',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Footer in Grid', 'cevian' ),
				'description'   => esc_html__( 'Enabling this option will place Footer content in grid', 'cevian' ),
				'parent'        => $footer_panel
			)
		);

        cevian_select_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'uncovering_footer',
                'default_value' => 'no',
                'label'         => esc_html__( 'Uncovering Footer', 'cevian' ),
                'description'   => esc_html__( 'Enabling this option will make Footer gradually appear on scroll', 'cevian' ),
                'parent'        => $footer_panel
            )
        );

		cevian_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_top',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Top', 'cevian' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Top area', 'cevian' ),
				'parent'        => $footer_panel
			)
		);
		
		$show_footer_top_container = cevian_select_add_admin_container(
			array(
				'name'       => 'show_footer_top_container',
				'parent'     => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_top' => 'yes'
					)
				)
			)
		);

		cevian_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns',
				'parent'        => $show_footer_top_container,
				'default_value' => '3 3 3 3',
				'label'         => esc_html__( 'Footer Top Columns', 'cevian' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Top area', 'cevian' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3',
                    '3 3 6' => '3 (25% + 25% + 50%)',
					'3 3 3 3' => '4'
				)
			)
		);

		cevian_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_top_columns_alignment',
				'default_value' => 'left',
				'label'         => esc_html__( 'Footer Top Columns Alignment', 'cevian' ),
				'description'   => esc_html__( 'Text Alignment in Footer Columns', 'cevian' ),
				'options'       => array(
					''       => esc_html__( 'Default', 'cevian' ),
					'left'   => esc_html__( 'Left', 'cevian' ),
					'center' => esc_html__( 'Center', 'cevian' ),
					'right'  => esc_html__( 'Right', 'cevian' )
				),
				'parent'        => $show_footer_top_container
			)
		);

        cevian_select_add_admin_field(
            array(
                'type'          => 'select',
                'name'          => 'footer_top_btt_skin',
                'default_value' => 'default',
                'label'         => esc_html__( 'Footer Top Back To Top Skin', 'cevian' ),
                'description'   => esc_html__( 'Choose Skin For Back To Top Button', 'cevian' ),
                'options'       => array(
                    'default' => 'Default',
                    'light' => 'Light'
                ),
                'parent'        => $show_footer_top_container
            )
        );
		
		$footer_top_styles_group = cevian_select_add_admin_group(
			array(
				'name'        => 'footer_top_styles_group',
				'title'       => esc_html__( 'Footer Top Styles', 'cevian' ),
				'description' => esc_html__( 'Define style for footer top area', 'cevian' ),
				'parent'      => $show_footer_top_container
			)
		);
		
		$footer_top_styles_row_1 = cevian_select_add_admin_row(
			array(
				'name'   => 'footer_top_styles_row_1',
				'parent' => $footer_top_styles_group
			)
		);
		
			cevian_select_add_admin_field(
				array(
					'name'   => 'footer_top_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'cevian' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			cevian_select_add_admin_field(
				array(
					'name'   => 'footer_top_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'cevian' ),
					'parent' => $footer_top_styles_row_1
				)
			);
			
			cevian_select_add_admin_field(
				array(
					'name'   => 'footer_top_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'cevian' ),
					'parent' => $footer_top_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);

		cevian_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'show_footer_bottom',
				'default_value' => 'yes',
				'label'         => esc_html__( 'Show Footer Bottom', 'cevian' ),
				'description'   => esc_html__( 'Enabling this option will show Footer Bottom area', 'cevian' ),
				'parent'        => $footer_panel
			)
		);

		$show_footer_bottom_container = cevian_select_add_admin_container(
			array(
				'name'            => 'show_footer_bottom_container',
				'parent'          => $footer_panel,
				'dependency' => array(
					'show' => array(
						'show_footer_bottom'  => 'yes'
					)
				)
			)
		);

		cevian_select_add_admin_field(
			array(
				'type'          => 'select',
				'name'          => 'footer_bottom_columns',
				'default_value' => '6 6',
				'label'         => esc_html__( 'Footer Bottom Columns', 'cevian' ),
				'description'   => esc_html__( 'Choose number of columns for Footer Bottom area', 'cevian' ),
				'options'       => array(
					'12' => '1',
					'6 6' => '2',
					'4 4 4' => '3'
				),
				'parent'        => $show_footer_bottom_container
			)
		);

        cevian_select_add_admin_field(
            array(
                'type'          => 'select',
                'name'          => 'footer_bottom_btt_skin',
                'default_value' => 'default',
                'label'         => esc_html__( 'Footer Bottom Back To Top Skin', 'cevian' ),
                'description'   => esc_html__( 'Choose Skin For Back To Top Button', 'cevian' ),
                'options'       => array(
                    'default' => 'Default',
                    'light' => 'Light'
                ),
                'parent'        => $show_footer_bottom_container
            )
        );

		$footer_bottom_styles_group = cevian_select_add_admin_group(
			array(
				'name'        => 'footer_bottom_styles_group',
				'title'       => esc_html__( 'Footer Bottom Styles', 'cevian' ),
				'description' => esc_html__( 'Define style for footer bottom area', 'cevian' ),
				'parent'      => $show_footer_bottom_container
			)
		);
		
		$footer_bottom_styles_row_1 = cevian_select_add_admin_row(
			array(
				'name'   => 'footer_bottom_styles_row_1',
				'parent' => $footer_bottom_styles_group
			)
		);
		
			cevian_select_add_admin_field(
				array(
					'name'   => 'footer_bottom_background_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Background Color', 'cevian' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			cevian_select_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_color',
					'type'   => 'colorsimple',
					'label'  => esc_html__( 'Border Color', 'cevian' ),
					'parent' => $footer_bottom_styles_row_1
				)
			);
			
			cevian_select_add_admin_field(
				array(
					'name'   => 'footer_bottom_border_width',
					'type'   => 'textsimple',
					'label'  => esc_html__( 'Border Width', 'cevian' ),
					'parent' => $footer_bottom_styles_row_1,
					'args'   => array(
						'suffix' => 'px'
					)
				)
			);
	}

	add_action( 'cevian_select_action_options_map', 'cevian_select_footer_options_map', cevian_select_set_options_map_position( 'footer' ) );
}