<?php

if ( ! function_exists( 'cevian_select_get_hide_dep_for_header_menu_area_options' ) ) {
	function cevian_select_get_hide_dep_for_header_menu_area_options() {
		$hide_dep_options = apply_filters( 'cevian_select_filter_header_menu_area_hide_global_option', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'cevian_select_header_menu_area_options_map' ) ) {
	function cevian_select_header_menu_area_options_map( $panel_header ) {
		$hide_dep_options = cevian_select_get_hide_dep_for_header_menu_area_options();
		
		$menu_area_container = cevian_select_add_admin_container_no_style(
			array(
				'parent'          => $panel_header,
				'name'            => 'menu_area_container',
				'dependency' => array(
					'hide' => array(
						'header_options'  => $hide_dep_options
					)
				),
			)
		);
		
		cevian_select_add_admin_section_title(
			array(
				'parent' => $menu_area_container,
				'name'   => 'menu_area_style',
				'title'  => esc_html__( 'Menu Area Style', 'cevian' )
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid',
				'default_value' => 'no',
				'label'         => esc_html__( 'Menu Area In Grid', 'cevian' ),
				'description'   => esc_html__( 'Set menu area content to be in grid', 'cevian' ),
			)
		);
		
		$menu_area_in_grid_container = cevian_select_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'menu_area_in_grid_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_in_grid'  => 'no'
					)
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'color',
				'name'          => 'menu_area_grid_background_color',
				'default_value' => '',
				'label'         => esc_html__( 'Grid Background Color', 'cevian' ),
				'description'   => esc_html__( 'Set grid background color for menu area', 'cevian' ),
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'text',
				'name'          => 'menu_area_grid_background_transparency',
				'default_value' => '',
				'label'         => esc_html__( 'Grid Background Transparency', 'cevian' ),
				'description'   => esc_html__( 'Set grid background transparency for menu area', 'cevian' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid_shadow',
				'default_value' => 'no',
				'label'         => esc_html__( 'Grid Area Shadow', 'cevian' ),
				'description'   => esc_html__( 'Set shadow on grid area', 'cevian' )
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_in_grid_border',
				'default_value' => 'no',
				'label'         => esc_html__( 'Grid Area Border', 'cevian' ),
				'description'   => esc_html__( 'Set border on grid area', 'cevian' )
			)
		);
		
		$menu_area_in_grid_border_container = cevian_select_add_admin_container(
			array(
				'parent'          => $menu_area_in_grid_container,
				'name'            => 'menu_area_in_grid_border_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_in_grid_border'  => 'no'
					)
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_in_grid_border_container,
				'type'          => 'color',
				'name'          => 'menu_area_in_grid_border_color',
				'default_value' => '',
				'label'         => esc_html__( 'Border Color', 'cevian' ),
				'description'   => esc_html__( 'Set border color for menu area', 'cevian' ),
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'color',
				'name'          => 'menu_area_background_color',
				'default_value' => '',
				'label'         => esc_html__( 'Background Color', 'cevian' ),
				'description'   => esc_html__( 'Set background color for menu area', 'cevian' )
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'text',
				'name'          => 'menu_area_background_transparency',
				'default_value' => '',
				'label'         => esc_html__( 'Background Transparency', 'cevian' ),
				'description'   => esc_html__( 'Set background transparency for menu area', 'cevian' ),
				'args'          => array(
					'col_width' => 3
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'parent'        => $menu_area_container,
				'type'          => 'yesno',
				'name'          => 'menu_area_shadow',
				'default_value' => 'no',
				'label'         => esc_html__( 'Menu Area Shadow', 'cevian' ),
				'description'   => esc_html__( 'Set shadow on menu area', 'cevian' ),
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'type'          => 'yesno',
				'name'          => 'menu_area_border',
				'default_value' => 'no',
				'label'         => esc_html__( 'Menu Area Border', 'cevian' ),
				'description'   => esc_html__( 'Set border on menu area', 'cevian' ),
				'parent'        => $menu_area_container
			)
		);
		
		$menu_area_border_container = cevian_select_add_admin_container(
			array(
				'parent'          => $menu_area_container,
				'name'            => 'menu_area_border_container',
				'dependency' => array(
					'hide' => array(
						'menu_area_border'  => 'no'
					)
				)
			)
		);

        cevian_select_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'menu_area_top_border',
                'default_value' => 'no',
                'label'         => esc_html__( 'Menu Area Top Border', 'cevian' ),
                'description'   => esc_html__( 'Set top border on menu area', 'cevian' ),
                'parent'        => $menu_area_border_container
            )
        );

        cevian_select_add_admin_field(
            array(
                'type'          => 'yesno',
                'name'          => 'menu_area_bottom_border',
                'default_value' => 'no',
                'label'         => esc_html__( 'Menu Area Bottom Border', 'cevian' ),
                'description'   => esc_html__( 'Set bottom border on menu area', 'cevian' ),
                'parent'        => $menu_area_border_container
            )
        );
		
		cevian_select_add_admin_field(
			array(
				'type'        => 'color',
				'name'        => 'menu_area_border_color',
				'label'       => esc_html__( 'Border Color', 'cevian' ),
				'description' => esc_html__( 'Set border color for menu area', 'cevian' ),
				'parent'      => $menu_area_border_container
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'type'        => 'text',
				'name'        => 'menu_area_height',
				'label'       => esc_html__( 'Height', 'cevian' ),
				'description' => esc_html__( 'Enter header height', 'cevian' ),
				'parent'      => $menu_area_container,
				'args'        => array(
					'col_width' => 3,
					'suffix'    => 'px'
				)
			)
		);
		
		cevian_select_add_admin_field(
			array(
				'type'   => 'text',
				'name'   => 'menu_area_side_padding',
				'label'  => esc_html__( 'Menu Area Side Padding', 'cevian' ),
				'parent' => $menu_area_container,
				'args'   => array(
					'col_width' => 2,
					'suffix'    => esc_html__( 'px or %', 'cevian' )
				)
			)
		);
		
		do_action( 'cevian_select_header_menu_area_additional_options', $panel_header );
	}
	
	add_action( 'cevian_select_action_header_menu_area_options_map', 'cevian_select_header_menu_area_options_map', 10, 1 );
}