(function($) {
	"use strict";
	
	var header = {};
	qodef.modules.header = header;
	
	header.qodefSetDropDownMenuPosition     = qodefSetDropDownMenuPosition;
	header.qodefSetDropDownWideMenuPosition = qodefSetDropDownWideMenuPosition;
	header.qodefBottomLineForMenu = qodefBottomLineForMenu;
	header.qodefLeftLineForMenu = qodefLeftLineForMenu;

	header.qodefOnDocumentReady = qodefOnDocumentReady;
	header.qodefOnWindowLoad = qodefOnWindowLoad;
	
	$(document).ready(qodefOnDocumentReady);
	$(window).on('load', qodefOnWindowLoad);
	
	/*
	 All functions to be called on $(document).ready() should be in this function
	 */
	function qodefOnDocumentReady() {
		qodefSetDropDownMenuPosition();
        qodefBottomLineForMenu();
        qodefLeftLineForMenu();
		setTimeout(function(){
			qodefDropDownMenu();
		}, 100);
	}
	
	/*
	 All functions to be called on $(window).on('load', ) should be in this function
	 */
	function qodefOnWindowLoad() {
		qodefSetDropDownWideMenuPosition();
	}
	
	/**
	 * Set dropdown position
	 */
	function qodefSetDropDownMenuPosition() {
		var menuItems = $('.qodef-drop-down > ul > li.narrow.menu-item-has-children');
		
		if (menuItems.length) {
			menuItems.each(function (i) {
				var thisItem = $(this),
					menuItemPosition = thisItem.offset().left,
					dropdownHolder = thisItem.find('.second'),
					dropdownMenuItem = dropdownHolder.find('.inner ul'),
					dropdownMenuWidth = dropdownMenuItem.outerWidth(),
					menuItemFromLeft = qodef.windowWidth - menuItemPosition;
				
				if (qodef.body.hasClass('qodef-boxed')) {
					menuItemFromLeft = qodef.boxedLayoutWidth - (menuItemPosition - (qodef.windowWidth - qodef.boxedLayoutWidth ) / 2);
				}
				
				var dropDownMenuFromLeft; //has to stay undefined because 'dropDownMenuFromLeft < dropdownMenuWidth' conditional will be true
				
				if (thisItem.find('li.sub').length > 0) {
					dropDownMenuFromLeft = menuItemFromLeft - dropdownMenuWidth;
				}
				
				dropdownHolder.removeClass('right');
				dropdownMenuItem.removeClass('right');
				if (menuItemFromLeft < dropdownMenuWidth || dropDownMenuFromLeft < dropdownMenuWidth) {
					dropdownHolder.addClass('right');
					dropdownMenuItem.addClass('right');
				}
			});
		}
	}
	
	/**
	 * Set dropdown wide position
	 */
	function qodefSetDropDownWideMenuPosition(){
		var menuItems = $(".qodef-drop-down > ul > li.wide");
		
		if(menuItems.length) {
			menuItems.each( function(i) {
                var menuItem = $(this);
				var menuItemSubMenu = menuItem.find('.second');
				
				if(menuItemSubMenu.length && !menuItemSubMenu.hasClass('left_position') && !menuItemSubMenu.hasClass('right_position')) {
					menuItemSubMenu.css('left', 0);
					
					var left_position = menuItemSubMenu.offset().left;
					
					if(qodef.body.hasClass('qodef-boxed')) {
                        //boxed layout case
                        var boxedWidth = $('.qodef-boxed .qodef-wrapper .qodef-wrapper-inner').outerWidth();
						left_position = left_position - (qodef.windowWidth - boxedWidth) / 2;
						menuItemSubMenu.css({'left': -left_position, 'width': boxedWidth});

					} else if(qodef.body.hasClass('qodef-wide-dropdown-menu-in-grid')) {
                        //wide dropdown in grid case
                        menuItemSubMenu.css({'left': -left_position + (qodef.windowWidth - qodef.gridWidth()) / 2, 'width': qodef.gridWidth()});

                    }
                    else {
                        //wide dropdown full width case
                        menuItemSubMenu.css({'left': -left_position, 'width': qodef.windowWidth});

					}
				}
			});
		}
	}
	
	function qodefDropDownMenu() {
		var menu_items = $('.qodef-drop-down > ul > li');
		
		menu_items.each(function() {
			var thisItem = $(this);
			
			if(thisItem.find('.second').length) {
				thisItem.waitForImages(function(){
					var dropDownHolder = thisItem.find('.second'),
						dropDownHolderHeight = !qodef.menuDropdownHeightSet ? dropDownHolder.outerHeight() : 0;
					
					if(thisItem.hasClass('wide')) {
						var tallest = 0,
							leftMenusecondItem = dropDownHolder.find('> .inner > ul > li');
						
						leftMenusecondItem.each(function() {
							var thisHeight = $(this).outerHeight();
							
							if(thisHeight > tallest) {
								tallest = thisHeight;
							}
						});
						
						leftMenusecondItem.css('height', '').height(tallest);
						
						if (!qodef.menuDropdownHeightSet) {
							dropDownHolderHeight = dropDownHolder.outerHeight();
						}
					}
					
					if (!qodef.menuDropdownHeightSet) {
						dropDownHolder.height(0);
					}
					
					if(navigator.userAgent.match(/(iPod|iPhone|iPad)/)) {
						thisItem.on("touchstart mouseenter", function() {
							dropDownHolder.css({
								'height': dropDownHolderHeight,
								'overflow': 'visible',
								'visibility': 'visible',
								'opacity': '1'
							});
						}).on("mouseleave", function() {
							dropDownHolder.css({
								'height': '0px',
								'overflow': 'hidden',
								'visibility': 'hidden',
								'opacity': '0'
							});
						});
					} else {
						if (qodef.body.hasClass('qodef-dropdown-animate-height')) {
							var animateConfig = {
								interval: 0,
								over: function () {
									setTimeout(function () {
										dropDownHolder.addClass('qodef-drop-down-start').css({
											'visibility': 'visible',
											'height': '0',
											'opacity': '1'
										});
										dropDownHolder.stop().animate({
											'height': dropDownHolderHeight
										}, 400, 'easeInOutQuint', function () {
											dropDownHolder.css('overflow', 'visible');
										});
									}, 100);
								},
								timeout: 100,
								out: function () {
									dropDownHolder.stop().animate({
										'height': '0',
										'opacity': 0
									}, 100, function () {
										dropDownHolder.css({
											'overflow': 'hidden',
											'visibility': 'hidden'
										});
									});
									
									dropDownHolder.removeClass('qodef-drop-down-start');
								}
							};
							
							thisItem.hoverIntent(animateConfig);
						} else {
							var config = {
								interval: 0,
								over: function () {
									setTimeout(function () {
										dropDownHolder.addClass('qodef-drop-down-start').stop().css({'height': dropDownHolderHeight});
									}, 150);
								},
								timeout: 150,
								out: function () {
									dropDownHolder.stop().css({'height': '0'}).removeClass('qodef-drop-down-start');
								}
							};
							
							thisItem.hoverIntent(config);
						}
					}
				});
			}
		});
		
		$('.qodef-drop-down ul li.wide ul li a').on('click', function(e) {
			if (e.which === 1){
				var $this = $(this);
				
				setTimeout(function() {
					$this.mouseleave();
				}, 500);
			}
		});
		
		qodef.menuDropdownHeightSet = true;
	}

	/*
	 ** Underlining effect for first level for Main Menu
	 */
    function qodefBottomLineForMenu() {
        var firstLevelMenus = $('.qodef-main-menu > ul');

        if (firstLevelMenus.length) {
            firstLevelMenus.each(function(){
                var mainMenu = $(this);

                mainMenu.append('<li class="qodef-main-menu-line"></li>');

                var menuLine = mainMenu.find('.qodef-main-menu-line'),
                    menuItems = mainMenu.find('> li.menu-item'),
                    initialOffset;

                if (menuItems.filter('.qodef-active-item').length) {
                    initialOffset = menuItems.filter('.qodef-active-item').offset().left;
                    menuLine.css('width', menuItems.filter('.qodef-active-item').outerWidth());
                } else {
                    initialOffset = menuItems.first().offset().left;
                    menuLine.css('width', menuItems.first().outerWidth());
                }

                //initial positioning
                menuLine.css('left',  initialOffset - mainMenu.offset().left);
                //menuLine.css('top',  Math.floor(menuItems.first().find('.item_text').offset().top - mainMenu.offset().top + menuItems.first().find('.item_text').height() + lineTopOffset));

                //fx on    
                menuItems.mouseenter(function(){
                    var menuItem = $(this),
                        menuItemWidth = menuItem.outerWidth(),
                        mainMenuOffset = mainMenu.offset().left,
                        menuItemOffset = menuItem.offset().left - mainMenuOffset;

                    menuLine.css('width', menuItemWidth);
                    menuLine.css('left', menuItemOffset);
                });

                //fx off    
                mainMenu.mouseleave(function(){
                    if (menuItems.filter('.qodef-active-item').length) {
                        menuLine.css('width', menuItems.filter('.qodef-active-item').outerWidth());
                    } else {
                        menuLine.css('width', menuItems.first().outerWidth());
                    }

                    menuLine.css('left', initialOffset - mainMenu.offset().left);
                });

            });
        }
    }

	/*
	 ** Underlining effect for first level for Fullscreen and Left Menu
	 */
    function qodefLeftLineForMenu() {
        var leftMenus = $('.qodef-fullscreen-menu > ul, .qodef-vertical-menu > ul');

        if (leftMenus.length) {
            leftMenus.each(function(){
                var leftMenu = $(this);

                leftMenu.append('<li class="qodef-menu-line"></li>');

                var menuLine = leftMenu.find('.qodef-menu-line'),
                    menuItems = leftMenu.find('> li.menu-item'),
                    initialOffset;

                if (menuItems.filter('.qodef-active-item').length) {
                    initialOffset = menuItems.filter('.qodef-active-item').find('> a > span').offset().top;
                    menuLine.css('height', menuItems.filter('.qodef-active-item').find('> a > span').outerHeight());
                } else {
                    initialOffset = menuItems.first().find('> a > span').offset().top;
                    menuLine.css('height', menuItems.first().find('> a > span').outerHeight());
                }

                //initial positioning
                menuLine.css('top',  initialOffset - leftMenu.offset().top);

                var lineMovement = function(menuItem, leftMenu) {
                    var menuItemHeight = menuItem.find('> a > span').height(),
                        menuOffset = leftMenu.offset().top,
                        correctiveFactor = parseInt(menuItem.find('> a > span').css('padding-top')),
                        menuItemOffset = menuItem.find('> a > span').offset().top  - menuOffset + correctiveFactor;

                    return {heightVal: menuItemHeight, topVal: menuItemOffset};
                }

                menuItems.each(function(){
                    var menuItem = $(this);

                    menuItem.mouseenter(function(){
                        var calcs = lineMovement(menuItem, leftMenu);

                        menuLine.css('height', calcs.heightVal);
                        menuLine.css('top', calcs.topVal);
                    });
                });

                //fx off
                leftMenu.mouseleave(function(){
                    if (menuItems.filter('.qodef-active-item').length) {
                        menuLine.css('height', menuItems.filter('.qodef-active-item').find('> a > span').outerHeight());
                        menuLine.css('top', menuItems.filter('.qodef-active-item').find('> a > span').offset().top  - leftMenu.offset().top);
                    } else {
                        menuLine.css('height', menuItems.first().find('> a > span').outerHeight());
                        menuLine.css('top', menuItems.first().find('> a > span').offset().top  - leftMenu.offset().top);
                    }

                    //menuLine.css('top', initialOffset - leftMenu.offset().top);
                });
            });
        }
    }
	
})(jQuery);