<?php

if ( ! function_exists( 'cevian_select_get_hide_dep_for_header_standard_meta_boxes' ) ) {
	function cevian_select_get_hide_dep_for_header_standard_meta_boxes() {
		$hide_dep_options = apply_filters( 'cevian_select_filter_header_standard_hide_meta_boxes', $hide_dep_options = array() );
		
		return $hide_dep_options;
	}
}

if ( ! function_exists( 'cevian_select_header_standard_meta_map' ) ) {
	function cevian_select_header_standard_meta_map( $parent ) {
		$hide_dep_options = cevian_select_get_hide_dep_for_header_standard_meta_boxes();
		
		cevian_select_create_meta_box_field(
			array(
				'parent'          => $parent,
				'type'            => 'select',
				'name'            => 'qodef_set_menu_area_position_meta',
				'default_value'   => '',
				'label'           => esc_html__( 'Choose Menu Area Position', 'cevian' ),
				'description'     => esc_html__( 'Select menu area position in your header', 'cevian' ),
				'options'         => array(
					''       => esc_html__( 'Default', 'cevian' ),
					'left'   => esc_html__( 'Left', 'cevian' ),
					'right'  => esc_html__( 'Right', 'cevian' ),
					'center' => esc_html__( 'Center', 'cevian' )
				),
				'dependency' => array(
					'hide' => array(
						'qodef_header_type_meta'  => $hide_dep_options
					)
				)
			)
		);
	}
	
	add_action( 'cevian_select_action_additional_header_area_meta_boxes_map', 'cevian_select_header_standard_meta_map' );
}