<?php

if ( ! function_exists( 'cevian_select_register_side_area_sidebar' ) ) {
	/**
	 * Register side area sidebar
	 */
	function cevian_select_register_side_area_sidebar() {
		register_sidebar(
			array(
				'id'            => 'sidearea',
				'name'          => esc_html__( 'Side Area', 'cevian' ),
				'description'   => esc_html__( 'Side Area', 'cevian' ),
				'before_widget' => '<div id="%1$s" class="widget qodef-sidearea %2$s">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="qodef-widget-title-holder"><h4 class="qodef-widget-title">',
				'after_title'   => '</h4></div>'
			)
		);
	}
	
	add_action( 'widgets_init', 'cevian_select_register_side_area_sidebar' );
}

if ( ! function_exists( 'cevian_select_side_menu_body_class' ) ) {
	/**
	 * Function that adds body classes for different side menu styles
	 *
	 * @param $classes array original array of body classes
	 *
	 * @return array modified array of classes
	 */
	function cevian_select_side_menu_body_class( $classes ) {
		
		if ( is_active_widget( false, false, 'qodef_side_area_opener' ) ) {
			
			if ( cevian_select_options()->getOptionValue( 'side_area_type' ) ) {
				$classes[] = 'qodef-' . cevian_select_options()->getOptionValue( 'side_area_type' );
			}
		}
		
		return $classes;
	}
	
	add_filter( 'body_class', 'cevian_select_side_menu_body_class' );
}

if ( ! function_exists( 'cevian_select_get_side_area' ) ) {
	/**
	 * Loads side area HTML
	 */
	function cevian_select_get_side_area() {
		
		if ( is_active_widget( false, false, 'qodef_side_area_opener' ) ) {
			$parameters = array(
				'close_icon_classes' => cevian_select_get_side_area_close_icon_class()
			);
			
			cevian_select_get_module_template_part( 'templates/sidearea', 'sidearea', '', $parameters );
		}
	}
	
	add_action( 'cevian_select_action_after_body_tag', 'cevian_select_get_side_area', 10 );
}

if ( ! function_exists( 'cevian_select_get_side_area_close_class' ) ) {
	/**
	 * Loads side area close icon class
	 */
	function cevian_select_get_side_area_close_icon_class() {
		$classes = array(
			'qodef-close-side-menu'
		);
		
		$classes[] = cevian_select_get_icon_sources_class( 'side_area', 'qodef-close-side-menu' );
		
		return $classes;
	}
}