<?php

if ( class_exists( 'CevianCoreClassWidget' ) ) {
	class CevianSelectClassSideAreaOpener extends CevianCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'qodef_side_area_opener',
				esc_html__( 'Cevian Side Area Opener', 'cevian' ),
				array( 'description' => esc_html__( 'Display a "hamburger" icon that opens the side area', 'cevian' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'        => 'colorpicker',
					'name'        => 'icon_color',
					'title'       => esc_html__( 'Side Area Opener Color', 'cevian' ),
					'description' => esc_html__( 'Define color for side area opener', 'cevian' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'icon_hover_color',
					'title'       => esc_html__( 'Side Area Opener Hover Color', 'cevian' ),
					'description' => esc_html__( 'Define hover color for side area opener', 'cevian' )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'widget_margin',
					'title'       => esc_html__( 'Side Area Opener Margin', 'cevian' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'cevian' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'widget_title',
					'title' => esc_html__( 'Side Area Opener Title', 'cevian' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			$classes = array(
				'qodef-side-menu-button-opener',
				'qodef-icon-has-hover'
			);
			
			$classes[] = cevian_select_get_icon_sources_class( 'side_area', 'qodef-side-menu-button-opener' );
			
			$styles = array();
			if ( ! empty( $instance['icon_color'] ) ) {
				$styles[] = 'color: ' . $instance['icon_color'] . ';';
			}
			if ( ! empty( $instance['widget_margin'] ) ) {
				$styles[] = 'margin: ' . $instance['widget_margin'];
			}
			?>
			<a <?php cevian_select_class_attribute( $classes ); ?> <?php echo cevian_select_get_inline_attr( $instance['icon_hover_color'], 'data-hover-color' ); ?> href="javascript:void(0)" <?php cevian_select_inline_style( $styles ); ?>>
				<?php if ( ! empty( $instance['widget_title'] ) ) { ?>
					<h5 class="qodef-side-menu-title"><?php echo esc_html( $instance['widget_title'] ); ?></h5>
				<?php } ?>
				<span class="qodef-side-menu-icon">
					<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
                         width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve">
                    <circle cx="2" cy="2" r="2"/>
                    <circle cx="12" cy="2" r="2"/>
                    <circle cx="22" cy="2" r="2"/>
                    <circle cx="2" cy="12" r="2"/>
                    <circle cx="12" cy="12" r="2"/>
                    <circle cx="22" cy="12" r="2"/>
                    <circle cx="2" cy="22" r="2"/>
                    <circle cx="12" cy="22" r="2"/>
                    <circle cx="22" cy="22" r="2"/>
                    </svg>
	            </span>
			</a>
		<?php }
	}
}