<?php

if ( ! function_exists( 'cevian_select_skewed_section_title_meta' ) ) {
	function cevian_select_skewed_section_title_meta( $show_title_area_container ) {
		
		cevian_select_add_admin_section_title(
			array(
				'parent' => $show_title_area_container,
				'name'   => 'skewed_section_container',
				'title'  => esc_html__( 'Skewed Section', 'cevian' )
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_enable_skewed_section_on_title_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Skewed Section', 'cevian' ),
				'description'   => esc_html__( 'This option will enable/disable Skew Section on Title Area', 'cevian' ),
				'options'       => cevian_select_get_yes_no_select_array(),
				'parent'        => $show_title_area_container
			)
		);
		
		$show_skewed_section_title_area_container = cevian_select_add_admin_container(
			array(
				'parent'     => $show_title_area_container,
				'name'       => 'show_skewed_section_title_area_container',
				'dependency' => array(
					'show' => array(
						'qodef_enable_skewed_section_on_title_area_meta' => 'yes'
					)
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_title_area_skewed_section_type_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Position', 'cevian' ),
				'description'   => esc_html__( 'Specify skewed section position', 'cevian' ),
				'parent'        => $show_skewed_section_title_area_container,
				'options'       => array(
					''        => esc_html__( 'Default', 'cevian' ),
					'outline' => esc_html__( 'Outline', 'cevian' ),
					'inset'   => esc_html__( 'Inset', 'cevian' )
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'parent'      => $show_skewed_section_title_area_container,
				'type'        => 'textarea',
				'name'        => 'qodef_title_area_skewed_section_svg_path_meta',
				'label'       => esc_html__( 'Skewed Section On Title Area SVG Path', 'cevian' ),
				'description' => esc_html__( 'Enter your Section On Title Area SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'cevian' ),
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'parent'      => $show_skewed_section_title_area_container,
				'type'        => 'color',
				'name'        => 'qodef_title_area_skewed_section_svg_color_meta',
				'label'       => esc_html__( 'Skewed Section Color', 'cevian' ),
				'description' => esc_html__( 'Choose a background color for Skewed Section', 'cevian' ),
			)
		);
	}
	
	add_action( 'cevian_select_action_additional_title_area_meta_boxes', 'cevian_select_skewed_section_title_meta', 20 );
}

if ( ! function_exists( 'cevian_select_skewed_section_header_meta' ) ) {
	function cevian_select_skewed_section_header_meta( $show_header_area_container ) {
		
		cevian_select_add_admin_section_title(
			array(
				'parent' => $show_header_area_container,
				'name'   => 'skewed_section_container',
				'title'  => esc_html__( 'Skewed Section', 'cevian' )
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_enable_skewed_section_on_header_area_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Enable Skewed Section', 'cevian' ),
				'description'   => esc_html__( 'This option will enable/disable Skew Section on Header Area', 'cevian' ),
				'options'       => cevian_select_get_yes_no_select_array(),
				'parent'        => $show_header_area_container
			)
		);
		
		$show_skewed_section_header_area_container = cevian_select_add_admin_container(
			array(
				'parent'     => $show_header_area_container,
				'name'       => 'show_skewed_section_header_area_container',
				'dependency' => array(
					'show' => array(
						'qodef_enable_skewed_section_on_header_area_meta' => 'yes'
					)
				)
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'parent'      => $show_skewed_section_header_area_container,
				'type'        => 'textarea',
				'name'        => 'qodef_header_area_skewed_section_svg_path_meta',
				'label'       => esc_html__( 'Skewed Section On Header Area SVG Path', 'cevian' ),
				'description' => esc_html__( 'Enter your Section On Header Area SVG path here. Please remove version and id attributes from your SVG path because of HTML validation', 'cevian' ),
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'parent'      => $show_skewed_section_header_area_container,
				'type'        => 'color',
				'name'        => 'qodef_header_area_skewed_section_svg_color_meta',
				'label'       => esc_html__( 'Skewed Section Color', 'cevian' ),
				'description' => esc_html__( 'Choose a background color for Skewed Section', 'cevian' ),
			)
		);
	}
	
	add_action( 'cevian_select_action_additional_header_area_meta_boxes', 'cevian_select_skewed_section_header_meta', 20 );
}