<?php

if ( class_exists( 'CevianCoreClassWidget' ) ) {
	class CevianSelectClassButtonWidget extends CevianCoreClassWidget {
		public function __construct() {
			parent::__construct(
				'qodef_button_widget',
				esc_html__( 'Cevian Button Widget', 'cevian' ),
				array( 'description' => esc_html__( 'Add button element to widget areas', 'cevian' ) )
			);
			
			$this->setParams();
		}
		
		protected function setParams() {
			$this->params = array(
				array(
					'type'    => 'dropdown',
					'name'    => 'type',
					'title'   => esc_html__( 'Type', 'cevian' ),
					'options' => array(
						'solid'   => esc_html__( 'Solid', 'cevian' ),
						'outline' => esc_html__( 'Outline', 'cevian' ),
						'simple'  => esc_html__( 'Simple', 'cevian' )
					)
				),
				array(
					'type'        => 'dropdown',
					'name'        => 'size',
					'title'       => esc_html__( 'Size', 'cevian' ),
					'options'     => array(
						'small'  => esc_html__( 'Small', 'cevian' ),
						'medium' => esc_html__( 'Medium', 'cevian' ),
						'large'  => esc_html__( 'Large', 'cevian' ),
						'huge'   => esc_html__( 'Huge', 'cevian' )
					),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'cevian' )
				),
				array(
					'type'    => 'textfield',
					'name'    => 'text',
					'title'   => esc_html__( 'Text', 'cevian' ),
					'default' => esc_html__( 'Button Text', 'cevian' )
				),
				array(
					'type'  => 'textfield',
					'name'  => 'link',
					'title' => esc_html__( 'Link', 'cevian' )
				),
                array(
					'type'  => 'dropdown',
					'name'  => 'enable_arrow',
					'title' => esc_html__( 'Enable Arrow', 'cevian' ),
                    'options' => cevian_select_get_yes_no_select_array()
				),
				array(
					'type'    => 'dropdown',
					'name'    => 'target',
					'title'   => esc_html__( 'Link Target', 'cevian' ),
                    'options' => cevian_select_get_link_target_array()
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'color',
					'title' => esc_html__( 'Color', 'cevian' )
				),
				array(
					'type'  => 'colorpicker',
					'name'  => 'hover_color',
					'title' => esc_html__( 'Hover Color', 'cevian' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'background_color',
					'title'       => esc_html__( 'Background Color', 'cevian' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'cevian' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_background_color',
					'title'       => esc_html__( 'Hover Background Color', 'cevian' ),
					'description' => esc_html__( 'This option is only available for solid button type', 'cevian' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'border_color',
					'title'       => esc_html__( 'Border Color', 'cevian' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'cevian' )
				),
				array(
					'type'        => 'colorpicker',
					'name'        => 'hover_border_color',
					'title'       => esc_html__( 'Hover Border Color', 'cevian' ),
					'description' => esc_html__( 'This option is only available for solid and outline button type', 'cevian' )
				),
				array(
					'type'        => 'textfield',
					'name'        => 'margin',
					'title'       => esc_html__( 'Margin', 'cevian' ),
					'description' => esc_html__( 'Insert margin in format: top right bottom left (e.g. 10px 5px 10px 5px)', 'cevian' )
				)
			);
		}
		
		public function widget( $args, $instance ) {
			$params = '';
			
			if ( ! is_array( $instance ) ) {
				$instance = array();
			}
			
			// Filter out all empty params
			$instance = array_filter( $instance, function ( $array_value ) {
				return trim( $array_value ) != '';
			} );
			
			// Default values
			if ( ! isset( $instance['text'] ) ) {
				$instance['text'] = 'Button Text';
			}
			
			// Generate shortcode params
			foreach ( $instance as $key => $value ) {
				$params .= " $key='$value' ";
			}

			if( isset( $instance['enable_arrow'] ) && $instance['enable_arrow'] == 'yes' ){
			    $params .= " custom_class='qodef-button-with-arrow' ";
            }
			
			echo '<div class="widget qodef-button-widget">';
			echo do_shortcode( "[qodef_button $params]" ); // XSS OK
			echo '</div>';
		}
	}
}