<?php

if ( ! function_exists( 'cevian_select_map_woocommerce_meta' ) ) {
	function cevian_select_map_woocommerce_meta() {
		
		$woocommerce_meta_box = cevian_select_create_meta_box(
			array(
				'scope' => array( 'product' ),
				'title' => esc_html__( 'Product Meta', 'cevian' ),
				'name'  => 'woo_product_meta'
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'        => 'qodef_product_featured_image_size',
				'type'        => 'select',
				'label'       => esc_html__( 'Dimensions for Product List Shortcode', 'cevian' ),
				'description' => esc_html__( 'Choose image layout when it appears in Select Product List - Masonry layout shortcode', 'cevian' ),
				'options'     => array(
					''                   => esc_html__( 'Default', 'cevian' ),
					'small'              => esc_html__( 'Small', 'cevian' ),
					'large-width'        => esc_html__( 'Large Width', 'cevian' ),
					'large-height'       => esc_html__( 'Large Height', 'cevian' ),
					'large-width-height' => esc_html__( 'Large Width Height', 'cevian' )
				),
				'parent'      => $woocommerce_meta_box
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_title_area_woo_meta',
				'type'          => 'select',
				'default_value' => '',
				'label'         => esc_html__( 'Show Title Area', 'cevian' ),
				'description'   => esc_html__( 'Disabling this option will turn off page title area', 'cevian' ),
				'options'       => cevian_select_get_yes_no_select_array(),
				'parent'        => $woocommerce_meta_box
			)
		);
		
		cevian_select_create_meta_box_field(
			array(
				'name'          => 'qodef_show_new_sign_woo_meta',
				'type'          => 'yesno',
				'default_value' => 'no',
				'label'         => esc_html__( 'Show New Sign', 'cevian' ),
				'description'   => esc_html__( 'Enabling this option will show new sign mark on product', 'cevian' ),
				'parent'        => $woocommerce_meta_box
			)
		);
	}
	
	add_action( 'cevian_select_action_meta_boxes_map', 'cevian_select_map_woocommerce_meta', 99 );
}