<?php

/**
 * Provide a admin area view for the plugin
 *
 * This file is used to markup the admin-facing aspects of the plugin.
 *
 * @link       https://gsoulinc.com
 * @since      1.0.0
 *
 * @package    GS_CRM
 * @subpackage GS_CRM/admin/partials
 */
?>

<!-- This file should primarily consist of HTML with a little bit of PHP. -->
<div class="wrap">

	<h1 class="wp-heading-inline">Billings</h1>
	<hr class="wp-header-end">

	<table class="wp-list-table widefat fixed striped table-view-list posts">
	<thead>
	<tr>
		<td  id='cb' class='manage-column column-cb check-column'>
			<label class="screen-reader-text" for="cb-select-all-1">Select All</label><input id="cb-select-all-1" type="checkbox" />
		</td>
		<th scope="col" id='title' class='manage-column column-title column-primary sortable desc'>Invoice #</th>
		<th scope="col" id='signal_number' class='manage-column column-signal_number'>Account #</th>
		<th scope="col" id='company' class='manage-column column-company'>Company</th>
		<th scope="col" id='billing-date' class='manage-column column-billing-date'>Billing Date</th>
		<th scope="col" id='billing-amount' class='manage-column column-billing-amount'>Amount</th>
		<th scope="col" id='status' class='manage-column column-status'>Status</th>
		<th scope="col" id='status' class='manage-column column-status'>Print</th>
	</tr>
	</thead>
<!--
	<div class="container">
		<div class="flex-container">
			<div class="billing_id">Invoice#</div>
			<div class="billing_id">Invoice#</div>
			<div class="billing_company">Company</div>
			<div class="billing_amount">Amount</div>
			<div class="billing_date">Due Date</div>
			<div class="billing_status">Status</div>
		</div>
-->
<?php
	global $wpdb;
	$billing_table 	= $wpdb->prefix . 'gs_billing'; 
	$posts_table 	= $wpdb->prefix . 'posts'; 
	$billing_date 	= date("m/d/Y", strtotime($meta["billing_date"][0]));
	$billing_qry 	= '
		SELECT * 
		FROM '.$billing_table.' AS billing 
		INNER JOIN '.$posts_table.' AS company
		ON billing.post_id = company.ID 
		WHERE  billing.billing_status LIKE 0 
		ORDER BY billing.id DESC';

	//echo $billing_qry;
	
	/*' 
    SELECT booking_calendars.cal_name
    FROM '.$wpdb->prefix.'booking_calendars AS booking_calendars
    INNER JOIN '. $wpdb->prefix.'booking_reservation AS booking_reservations
    ON booking_calendars.id =  booking_reservations.calendar_id
    WHERE status LIKE "pending"'
	*/
	$results = $wpdb->get_results($billing_qry);

	foreach($results as $row)
	{
		//print_r($row);
		$meta = get_post_meta($row->ID, '', true);
		$billing_due 	= date("m/d/Y", strtotime($meta["billing_date"][0]));
		$billing_address = "";
		if($meta["billing_diff"][0]==1){
			$billing_address = $meta["billing_address"][0].' '.$meta["billing_address2"][0].' '.$meta["billing_city"][0].', '.$meta["billing_state"][0].' '.$meta["billing_zip"][0];
		}else{
			$billing_address = $meta["com_address"][0].' '.$meta["com_address2"][0].' '.$meta["com_city"][0].', '.$meta["com_state"][0].' '.$meta["com_zip"][0];
		}
		$billing_status = $row->billing_status;
		switch ($i) {
			case 0:
				$b_status = "Unpaid";
			break;
			case 1:
				$b_status = "Paid Check";
			break;
			case 2:
				$b_status = "Paid Cash";
			break;
			case 3:
				$b_status = "Paid Card";
			break;
		}
		$company_edit = get_edit_post_link($row->ID);
		$company_view = get_permalink($row->ID);
	?>
	<tr id="post-<?php echo $row->ID;?>" class="iedit author-self level-0 post-<?php echo $row->ID;?> type-company status-publish hentry category-alaram-customers entry">
		<th scope="row" class="check-column">
			<label class="screen-reader-text" for="cb-select-<?php echo $row->ID;?>"><?php echo $row->billing_id;?></label>
			<input id="cb-select-<?php echo $row->ID;?>" type="checkbox" name="post[]" value="<?php echo $row->ID;?>" />
			<div class="locked-indicator">
				<span class="locked-indicator-icon" aria-hidden="true"></span>
				<span class="screen-reader-text">&#8220;<?php echo $row->billing_id;?>&#8221; is locked</span>
			</div>
		</th>
		<td class='inv_num column-inv-num' data-colname="Invoice Number"><?php echo $row->billing_id;?></td>
		<td class='signal_number column-signal_number' data-colname="Account Number"><?php echo $row->billing_account;?></td>
		<td class='company column-company' data-colname="Author"><a href="post.php?post=<?php echo $row->ID;?>&action=edit"><?php echo $row->post_title;?></a></td>
		<td class='billing-date column-billing-date ' data-colname="BillingDate"><?php echo $billing_due;?></td>
		<td class='billing-amount column-billing-amount '>$<?php echo $row->billing_total;?></td>
		<td class='status column-status ' data-colname="Status"><?php echo $b_status;?></td>
		<td class='pdf column-pdf ' data-colname="PDF"><a href="<?php echo esc_url( get_permalink($row->ID) );?>" target="_blank">Print</a></td>
		<!--
		<td class='pdf column-pdf ' data-colname="PDF"><a href="/wp-admin/admin.php?page=gs-crm-pdf&#038;inv_id=<?php echo $row->ID;?>">Print</a></td>
		-->
	</tr>
	<?php
	}		
	?>
		
	</tbody>

	<tfoot>
	<tr>
		<td class='manage-column column-cb check-column'>
			<label class="screen-reader-text" for="cb-select-all-2">Select All</label>
			<input id="cb-select-all-2" type="checkbox" />
		</td>
		<th scope="col"  class='manage-column column-title column-primary sortable desc'>Invoice #</th>
		<th scope="col"  class='manage-column column-signal_number'>Account #</th>
		<th scope="col"  class='manage-column column-author '>Company</th>
		<th scope="col"  class='manage-column column-categories '>Date</th>
		<th scope="col"  class='manage-column column-tags '>Amount</th>
		<th scope="col"  class='manage-column column-tags '>Status</th>
		<th scope="col"  class='manage-column column-date sortable asc'>Print</th>	
	</tr>
	</tfoot>

	</table>
	
	</div>
</div>